/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools;

import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;

public class BdfHref
implements CharSequence {
    private final StringBuilder buf = new StringBuilder();
    private boolean first = true;

    public BdfHref(String href, boolean first) {
        this.buf.append(href);
        this.first = first;
    }

    public BdfHref page(String pageName) {
        return this.param("page", pageName);
    }

    public BdfHref pageErr(String pageName) {
        return this.param("page-err", pageName);
    }

    public BdfHref stream(String streamName) {
        return this.param("stream", streamName);
    }

    public BdfHref command(String commandName) {
        return this.param("cmd", commandName);
    }

    public BdfHref param(String paramName, String paramValue) {
        if (paramValue == null) {
            return this;
        }
        this.testFirst();
        this.buf.append(paramName);
        this.buf.append("=");
        this.buf.append(paramValue);
        return this;
    }

    public BdfHref sqlExport(String sqlExportName) {
        return this.param("sqlexport", sqlExportName);
    }

    public BdfHref scrutariExport(String scrutariExportName) {
        return this.param("scrutariexport", scrutariExportName);
    }

    public BdfHref tableExport(String tableExportName) {
        return this.param("tableexport", tableExportName);
    }

    public BdfHref balayage(String balayageName) {
        return this.param("balayage", balayageName);
    }

    public BdfHref refresh() {
        return this.param("refresh", String.valueOf(System.currentTimeMillis()));
    }

    public BdfHref subset(Subset subset) {
        return this.subset(subset.getSubsetKey());
    }

    public BdfHref subset(SubsetKey subsetKey) {
        return this.param(subsetKey.getCategoryString(), subsetKey.getSubsetName());
    }

    public BdfHref subsetItem(SubsetItem subsetItem) {
        SubsetKey subsetKey = subsetItem.getSubsetKey();
        this.subset(subsetKey);
        this.buf.append('&');
        this.buf.append("id");
        this.buf.append("=");
        this.buf.append(subsetItem.getId());
        return this;
    }

    public BdfHref derive(String paramName, String paramValue) {
        BdfHref newInstance = new BdfHref(this.buf.toString(), this.first);
        return newInstance.param(paramName, paramValue);
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }

    @Override
    public int length() {
        return this.buf.length();
    }

    @Override
    public char charAt(int index) {
        return this.buf.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buf.subSequence(start, end);
    }

    private void testFirst() {
        if (this.first) {
            this.buf.append('?');
            this.first = false;
        } else {
            this.buf.append('&');
        }
    }
}

