/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.StorageRoot;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.text.RelativePath;

public class StorageRootImpl
implements StorageRoot {
    private final Map<String, StorageRoot.Lock> lockMap = new HashMap<String, StorageRoot.Lock>();
    private final File rootDirectory;

    public StorageRootImpl(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    public File getFile(RelativePath filePath) {
        if (filePath.isEmpty()) {
            return this.rootDirectory;
        }
        return new File(this.rootDirectory, filePath.getPath());
    }

    @Override
    public StorageRoot.Lock getLock(RelativePath filePath) {
        StorageRoot.Lock lock = this.lockMap.get(filePath.getPath());
        if (lock == null) {
            return this.getOrCreateLock(filePath);
        }
        return lock;
    }

    private synchronized StorageRoot.Lock getOrCreateLock(RelativePath filePath) {
        String path = filePath.getPath();
        StorageRoot.Lock lock = this.lockMap.get(path);
        if (lock == null) {
            lock = new InternalLock();
            this.lockMap.put(path, lock);
        }
        return lock;
    }

    private static class InternalLock
    implements StorageRoot.Lock {
        private InternalLock() {
        }
    }
}

