/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.multi.subscribe.SubscribeManager;
import fr.exemole.bdfserver.multi.subscribe.SubscribeToken;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.email.EmailUtils;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.smtp.SmtpParameters;
import net.mapeadores.util.text.StringUtils;

class SubscribeManagerImpl
implements SubscribeManager {
    private final SmtpParameters smtpParameters;
    private final Map<String, SubscribeToken> tokenMap = new HashMap<String, SubscribeToken>();

    SubscribeManagerImpl(SmtpParameters smtpParameters) {
        this.smtpParameters = smtpParameters;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public CommandMessage sendToken(PersonCore person, EmailCore email, MessageLocalisation messageLocalisation, String multiRootUrl) throws ErrorMessageException {
        EmailCore fromEmail = this.smtpParameters.getEmail("subscribe.from");
        EmailCore replyEmail = this.smtpParameters.getEmail("subscribe.replyto");
        EmailCore bccEmail = this.smtpParameters.getEmail("subscribe.bcc");
        SubscribeToken subscribeToken = this.createToken(person, email);
        String url = multiRootUrl + "multi-subscribe?token=" + subscribeToken.getToken();
        Session session = EmailUtils.createSession(this.smtpParameters);
        MimeMessage mimeMessage = new MimeMessage(session);
        MimeMultipart messageContent = new MimeMultipart();
        try {
            mimeMessage.setFrom((Address)EmailUtils.convert(fromEmail));
            mimeMessage.setRecipient(Message.RecipientType.TO, (Address)EmailUtils.convert(email));
            if (replyEmail != null) {
                Address[] addresses = new Address[]{EmailUtils.convert(replyEmail)};
                mimeMessage.setReplyTo(addresses);
            }
            if (bccEmail != null) {
                mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)EmailUtils.convert(bccEmail));
            }
            mimeMessage.setSubject(messageLocalisation.toString("_ title.subscribe.email"), "utf-8");
            MimeBodyPart part = new MimeBodyPart();
            part.setText(this.getTokenContent(messageLocalisation, person, url));
            messageContent.addBodyPart((BodyPart)part);
            mimeMessage.setContent((Multipart)messageContent);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw BdfErrors.error("_ error.exception.sendreport_error", e.getMessage());
        }
        return LogUtils.done("_ done.subscribe.sendtoken", fromEmail.getAddrSpec(), email.getAddrSpec());
    }

    @Override
    public SubscribeToken getSubcribeToken(String token) {
        this.clearTokens();
        return this.tokenMap.get(token);
    }

    private String getTokenContent(MessageLocalisation messageLocalisation, PersonCore person, String url) {
        StringBuilder buf = new StringBuilder();
        buf.append(messageLocalisation.toString("_ info.subscribe.email_hello", person.toStandardStyle()));
        buf.append("\n\n");
        buf.append(messageLocalisation.toString("_ info.subscribe.email_intro", person.toStandardStyle()));
        buf.append("\n\n");
        buf.append(url);
        buf.append("\n\n");
        buf.append(messageLocalisation.toString("_ info.subscribe.email_warning", person.toStandardStyle()));
        return buf.toString();
    }

    private SubscribeToken createToken(PersonCore person, EmailCore email) {
        String token = StringUtils.getRandomToken(33);
        if (this.tokenMap.containsKey(token)) {
            return this.createToken(person, email);
        }
        SubscribeToken subscribeToken = new SubscribeToken(token, person, email);
        this.tokenMap.put(token, subscribeToken);
        return subscribeToken;
    }

    private void clearTokens() {
        ArrayList<SubscribeToken> list = new ArrayList<SubscribeToken>(this.tokenMap.values());
        for (SubscribeToken token : list) {
            if (!token.isRemoveable()) continue;
            this.tokenMap.remove(token.getToken());
        }
    }
}

