/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.multi.tools.PresenceInfo;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class CentralEmailChangeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralEmailChange";

    public CentralEmailChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        this.initCentralSphere();
        this.initCentralUser();
        EmailCore newEmail = this.getEmail();
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            done = this.getCentralUserEditor().setEmail(newEmail);
            this.saveChanges();
        }
        if (done) {
            List<PresenceInfo> presenceInfoList = PresenceInfo.scan(this.multi, this.centralUser, false);
            for (PresenceInfo presenceInfo : presenceInfoList) {
                BdfServer currentBdfServer;
                Redacteur redacteur = presenceInfo.getRedacteur();
                if (redacteur == null) continue;
                BdfServer bdfServer = currentBdfServer = presenceInfo.getBdfServer();
                synchronized (bdfServer) {
                    try (EditSession editSession = this.newEditSession(currentBdfServer, COMMAND_NAME);){
                        SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(redacteur.getSubsetKey());
                        sphereEditor.setEmail(redacteur, newEmail);
                    }
                }
            }
        }
        if (done) {
            return this.done("_ done.sphere.emailchange");
        }
        return null;
    }

    private EmailCore getEmail() throws ErrorMessageException {
        String email = StringUtils.cleanString(this.requestMap.getParameter("email"));
        if (email == null || email.length() == 0) {
            return null;
        }
        try {
            return EmailCoreUtils.parse(email);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.email", email);
        }
    }
}

