/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.importation;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.importation.FicheblockSyntaxJsonProperty;
import fr.exemole.bdfserver.jsonproducers.importation.MetaReportJsonProperty;
import fr.exemole.bdfserver.jsonproducers.importation.ParseResultJsonProperty;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.html.MetaReport;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ImportationJsonProducerFactory {
    private ImportationJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = ImportationJsonProducerFactory.getJsonProperty(parameters, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputParameters parameters, String name) throws ErrorMessageException {
        MessageLocalisation messageLocalisation = parameters.getMessageLocalisation();
        switch (name) {
            case "parseresult": {
                ParseResult parseResult = (ParseResult)parameters.getResultObject("obj.parseresult");
                if (parseResult != null) {
                    return new ParseResultJsonProperty(parameters.getBdfServer(), parseResult, messageLocalisation);
                }
                throw BdfErrors.missingCommandResultJson("parseresult");
            }
            case "metareport": {
                MetaReport metaReport = (MetaReport)parameters.getResultObject("obj.metareport");
                if (metaReport != null) {
                    return new MetaReportJsonProperty(metaReport);
                }
                throw BdfErrors.missingCommandResultJson("metareport");
            }
            case "ficheblocksyntax": {
                FicheBlocks ficheBlocks = (FicheBlocks)parameters.getResultObject("obj.ficheblocks");
                if (ficheBlocks != null) {
                    return new FicheblockSyntaxJsonProperty(ficheBlocks);
                }
                throw BdfErrors.missingCommandResultJson("ficheblocksyntax");
            }
        }
        return null;
    }
}

