/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.json.SubsetTreeJson;
import java.io.IOException;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public class SubsetTreesJsonProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final PermissionSummary permissionSummary;
    private final short[] categoryArray;
    private final boolean withDetails;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;

    public SubsetTreesJsonProperty(BdfServer bdfServer, PermissionSummary permissionSummary, Lang lang, short[] categoryArray, boolean withDetails) {
        this.bdfServer = bdfServer;
        this.permissionSummary = permissionSummary;
        this.categoryArray = categoryArray;
        this.withDetails = withDetails;
        this.lang = lang;
        this.messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(lang);
    }

    @Override
    public String getName() {
        return "subsetTrees";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        SubsetTreeJson.Parameters parameters = SubsetTreeJson.initParameters(this.bdfServer, this.lang, this.messageLocalisation).setWithPermissionSummary(this.permissionSummary).setWithDetails(this.withDetails);
        jw.object();
        for (short category : this.categoryArray) {
            SubsetTreeJson.properties(jw, parameters, category);
        }
        jw.endObject();
    }
}

