/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationHtmlUtils;
import java.util.Map;
import net.fichotheque.tools.importation.parsers.corpus.CorpusRowParser;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;

public class CorpusImportHtmlProducer
extends BdfServerHtmlProducer {
    public CorpusImportHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addJsLib(MiscJsLibs.IMPORTATION);
        this.addThemeCss("importation.css");
    }

    @Override
    public void printHtml() {
        Map<String, String> storeMap = this.getStoredValues("form_import_corpus");
        String currentType = CorpusImportHtmlProducer.getCurrentType(storeMap);
        this.start();
        this.printCommandMessageUnit();
        SubsetTree corpusTree = this.bdfServer.getTreeManager().getSubsetTree((short)1);
        CommandBox commandBox = CommandBox.init().action("importation").family("CRP").page("importation-confirm").target("_blank").multipart(true).name("CorpusImportParse").lockey("_ IMP-01").submitLocKey("_ submit.importation.parse");
        this.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.importation.corpus", this.name("corpus").attr("data-subset", "selection"), SubsetTreeOptions.init(corpusTree, this.bdfServer, this.workingLang).onlyNames(true).selectedSubsetKey((short)1, storeMap).withKeys(true))).__(Grid.choiceSetRow((Object)"_ label.importation.corpusimporttype", () -> this.__(Grid.radioCell((Object)"_ label.importation.corpusimporttype_creation", this.getTypeRadioAttributes("creation", currentType), () -> this.__(Grid.START).__(Grid.textInputRow("_ label.importation.defaultowners", this.name("defaultowners").cols(30).value(this.getDefaultOwners(storeMap)).populate(Appelant.user().sphere(this.bdfUser)))).__(Grid.END))).__(Grid.radioCell("_ label.importation.corpusimporttype_change", this.getTypeRadioAttributes("change", currentType))).__(Grid.radioCell("_ label.importation.corpusimporttype_remove", this.getTypeRadioAttributes("remove", currentType))))).__(ImportationHtmlUtils.printImportParseRows(this, storeMap)).__(Grid.END).__end(commandBox);
        this.end();
    }

    private HtmlAttributes getTypeRadioAttributes(String type, String current) {
        boolean checked = type.equals(current);
        return this.name("type").value(type).checked(checked);
    }

    private String getDefaultOwners(Map<String, String> storeMap) {
        String value = storeMap.get("defaultowners");
        if (value != null) {
            return value;
        }
        return this.bdfUser.getRedacteur().getBracketStyle() + ";";
    }

    private static String getCurrentType(Map<String, String> storeMap) {
        String defaultType = "creation";
        String current = storeMap.get("type");
        if (current == null) {
            return defaultType;
        }
        try {
            return CorpusRowParser.checkType(current);
        }
        catch (IllegalArgumentException iae) {
            return defaultType;
        }
    }
}

