/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.fichotheque.Fichotheque;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrase;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class LabelsOdsProducer
implements StreamProducer {
    private final String fileName;
    private final BdfServer bdfServer;

    public LabelsOdsProducer(BdfServer bdfServer, String fileName) {
        this.fileName = fileName;
        this.bdfServer = bdfServer;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        OdZipEngine.run(outputStream, OdZip.spreadSheet().contentOdSource(new ContentOdSource()));
    }

    private class ContentOdSource
    implements OdSource {
        private ContentOdSource() {
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            LabelsXMLPart labelsXMLPart = new LabelsXMLPart(xmlWriter, LabelsOdsProducer.this.bdfServer);
            labelsXMLPart.start();
            labelsXMLPart.addTable();
            labelsXMLPart.end();
            buf.flush();
        }
    }

    private static class LabelsXMLPart
    extends XMLPart {
        private final UiManager uiManager;
        private final Fichotheque fichotheque;
        private final Lang[] langArray;

        private LabelsXMLPart(XMLWriter xmlWriter, BdfServer bdfServer) {
            super(xmlWriter);
            this.uiManager = bdfServer.getUiManager();
            this.fichotheque = bdfServer.getFichotheque();
            this.langArray = LangsUtils.toArray(bdfServer.getLangConfiguration().getWorkingLangs());
        }

        public void start() throws IOException {
            OdXML.openDocumentContent(this);
            OdXML.openBody(this);
            OdXML.openSpreadsheet(this);
        }

        public void end() throws IOException {
            OdXML.closeSpreadsheet(this);
            OdXML.closeBody(this);
            OdXML.closeDocumentContent(this);
        }

        public void addTable() throws IOException {
            OdXML.openTable(this, "libs");
            this.addFirstRow();
            this.addMetadata(this.fichotheque.getFichothequeMetadata(), "fichotheque");
            for (Corpus corpus : this.fichotheque.getCorpusList()) {
                this.addMetadata(corpus);
                this.addCorpus(corpus);
            }
            for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
                this.addMetadata(thesaurus);
            }
            for (Sphere sphere : this.fichotheque.getSphereList()) {
                this.addMetadata(sphere);
            }
            for (Album album : this.fichotheque.getAlbumList()) {
                this.addMetadata(album);
            }
            for (Addenda addenda : this.fichotheque.getAddendaList()) {
                this.addMetadata(addenda);
            }
            OdXML.closeTable(this);
        }

        private void addMetadata(Subset subset) throws IOException {
            this.addMetadata(subset.getMetadata(), subset.getSubsetKeyString());
        }

        private void addMetadata(Metadata metadata, String rootKey) throws IOException {
            this.addLabelRow(rootKey + "/title", metadata.getTitleLabels());
            for (Phrase phrase : metadata.getPhrases()) {
                String key = rootKey + "/phrase_" + phrase.getName();
                this.addLabelRow(key, phrase);
            }
        }

        private void addCorpus(Corpus corpus) throws IOException {
            String rootKey = corpus.getSubsetKeyString();
            for (CorpusField corpusField : CorpusMetadataUtils.getCorpusFieldList(corpus.getCorpusMetadata())) {
                String key = rootKey + "/" + corpusField.getFieldString();
                this.addLabelRow(key, corpusField.getLabels());
            }
            UiComponents uiComponents = this.uiManager.getMainUiComponents(corpus);
            for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
                IncludeUi includeUi;
                Labels customLabels;
                if (!(uiComponent instanceof IncludeUi) || (customLabels = (includeUi = (IncludeUi)uiComponent).getCustomLabels()) == null) continue;
                String key = rootKey + "/" + includeUi.getName();
                this.addLabelRow(key, customLabels);
            }
        }

        private void addFirstRow() throws IOException {
            OdXML.openTableRow(this);
            OdXML.addStringTableCell(this, "key");
            for (Lang lang : this.langArray) {
                OdXML.addStringTableCell(this, "lib_" + lang.toString());
            }
            OdXML.closeTableRow(this);
        }

        private void addLabelRow(String key, Labels labels) throws IOException {
            OdXML.openTableRow(this);
            OdXML.addStringTableCell(this, key);
            for (Lang lang : this.langArray) {
                Label label = labels.getLabel(lang);
                if (label == null) {
                    OdXML.addEmptyTableCell(this);
                    continue;
                }
                OdXML.addStringTableCell(this, label.getLabelString());
            }
            OdXML.closeTableRow(this);
        }
    }
}

