/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.instructions.AccessInstruction;
import fr.exemole.bdfserver.get.instructions.AdminInstruction;
import fr.exemole.bdfserver.get.instructions.BalayagesInstruction;
import fr.exemole.bdfserver.get.instructions.DiagramsInstruction;
import fr.exemole.bdfserver.get.instructions.DocumentsInstruction;
import fr.exemole.bdfserver.get.instructions.FichesInstruction;
import fr.exemole.bdfserver.get.instructions.MotclesInstruction;
import fr.exemole.bdfserver.get.instructions.StreamInstruction;
import fr.exemole.bdfserver.get.instructions.TablesInstruction;
import fr.exemole.bdfserver.get.instructions.UsersInstruction;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.RedirectBdfInstruction;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;

public final class GetInstructionFactory {
    private GetInstructionFactory() {
    }

    public static BdfInstruction getBdfInstruction(BdfServer bdfServer, RequestMap requestMap, String dirName, String filePath) {
        switch (dirName) {
            case "admin": {
                return new AdminInstruction(bdfServer, filePath);
            }
            case "api": {
                return AccessInstruction.build(bdfServer, requestMap, filePath);
            }
            case "balayages": {
                return new BalayagesInstruction(bdfServer, filePath);
            }
            case "diagrams": {
                return new DiagramsInstruction(bdfServer, filePath);
            }
            case "documents": {
                return DocumentsInstruction.build(bdfServer, filePath);
            }
            case "ext": {
                int idxext = filePath.indexOf(47);
                if (idxext == -1) {
                    return new RedirectBdfInstruction(filePath + "/");
                }
                String extensionName = filePath.substring(0, idxext);
                String extensionPath = filePath.substring(idxext);
                ExtensionManager manager = bdfServer.getExtensionManager();
                BdfExtensionReference bdfExtensionReference = manager.getBdfExtensionReference(extensionName);
                if (bdfExtensionReference == null) {
                    if (filePath.endsWith("/")) {
                        return GetInstructionFactory.getExtensionError(bdfServer, requestMap, extensionName);
                    }
                    return null;
                }
                BdfInstructionProvider bdfInstructionProvider = (BdfInstructionProvider)bdfExtensionReference.getImplementation(BdfInstructionProvider.class);
                if (bdfInstructionProvider == null) {
                    return null;
                }
                return bdfInstructionProvider.getBdfInstruction(bdfServer, extensionPath, requestMap);
            }
            case "fiches": {
                return new FichesInstruction(bdfServer, requestMap, filePath);
            }
            case "motcles": 
            case "motscles": {
                return new MotclesInstruction(bdfServer, filePath, requestMap);
            }
            case "tables": {
                return new TablesInstruction(bdfServer, filePath, requestMap);
            }
            case "users": 
            case "redacteurs": {
                return new UsersInstruction(bdfServer, filePath);
            }
        }
        return new StreamInstruction(bdfServer, requestMap, dirName, filePath);
    }

    private static BdfInstruction getExtensionError(BdfServer bdfServer, RequestMap requestMap, String extensionName) {
        return new ErrorBdfInstruction(bdfServer, requestMap, new CommandMessage[]{LogUtils.error("_ error.unknown.extension", extensionName)});
    }

    private static class ErrorBdfInstruction
    implements BdfInstruction {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;
        private final CommandMessage[] errorMessages;

        private ErrorBdfInstruction(BdfServer bdfServer, RequestMap requestMap, CommandMessage ... errorMessages) {
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
            this.errorMessages = errorMessages;
        }

        @Override
        public short getBdfUserNeed() {
            return 2;
        }

        @Override
        public ResponseHandler runInstruction(BdfUser bdfUser) {
            MessageLocalisation messageLocalisation = BdfInstructionUtils.getMessageLocalisation(this.requestMap, this.bdfServer, bdfUser);
            return ResponseHandlerFactory.getInstance(messageLocalisation, this.requestMap, this.errorMessages);
        }
    }
}

