/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email.datasource;

import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.activation.DataSource;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

class XsltStreamDataSource
implements DataSource {
    private static final Map<String, String> EMPTY_OUTPUTPROPERTIES = Collections.emptyMap();
    private final String name;
    private final String extractionString;
    private final StreamTemplate.Xslt streamTemplate;
    private final TransformerParameters transformerParameters;

    XsltStreamDataSource(String name, StreamTemplate.Xslt streamTemplate, String extractionString, TransformerParameters transformerParameters) {
        this.name = name;
        this.streamTemplate = streamTemplate;
        this.extractionString = extractionString;
        this.transformerParameters = transformerParameters;
    }

    public String getContentType() {
        return this.streamTemplate.getMimeType();
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream byteoutput = new ByteArrayOutputStream();
        try {
            this.streamTemplate.transform(this.extractionString, byteoutput, this.transformerParameters.getMap(), EMPTY_OUTPUTPROPERTIES);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
        return new ByteArrayInputStream(byteoutput.toByteArray());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("no editable source");
    }
}

