/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email.datasource;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.activation.DataSource;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.exportation.table.CsvTableWriter;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.tools.exportation.table.TableExportOds;
import net.fichotheque.tools.exportation.table.TableExportOdsFactory;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.IOUtils;

public class TableExportDataSource
implements DataSource {
    private final String name;
    private final String contentType;
    private final String charset;
    private final String content;
    private final byte[] contentArray;

    private TableExportDataSource(String name, String contentType, String charset, String content) {
        this.name = name;
        this.contentType = contentType;
        this.charset = charset;
        this.content = content;
        this.contentArray = null;
    }

    private TableExportDataSource(String name, String contentType, byte[] contentArray) {
        this.name = name;
        this.contentType = contentType;
        this.charset = null;
        this.content = null;
        this.contentArray = contentArray;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        if (this.content != null) {
            return IOUtils.toInputStream(this.content, this.charset);
        }
        return new ByteArrayInputStream(this.contentArray);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("no editable source");
    }

    public static TableExportDataSource build(BdfParameters bdfParameters, Subset subset, Collection<SubsetItem> subsetItems, TableExportParameters tableExportParameters, String extension, String charset) {
        String contentType;
        TableExport tableExport;
        BdfServer bdfServer = bdfParameters.getBdfServer();
        PermissionSummary permissionSummary = bdfParameters.getPermissionSummary();
        BdfUser bdfUser = bdfParameters.getBdfUser();
        if (!permissionSummary.hasAccess(subset)) {
            throw new IllegalStateException("Not access to subset");
        }
        SubsetKey subsetKey = subset.getSubsetKey();
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(subsetKey);
        TableExportManager tableExportManager = bdfServer.getTableExportManager();
        SubsetTable subsetTable = null;
        String tableExportName = tableExportParameters.getTableExportName();
        TableExportDef tableExportDef = null;
        if (tableExportName != null && (tableExport = tableExportManager.getTableExport(tableExportName)) != null) {
            tableExportDef = tableExport.getTableExportDef();
            subsetTable = tableExport.getSubsetTable(subsetKey);
            if (subsetTable != null) {
                nameBuilder.append("-");
                nameBuilder.append(tableExportName);
            }
        }
        if (subsetTable == null) {
            subsetTable = BdfTableExportUtils.toDefaultSubsetTable(bdfServer, subset, tableExportParameters.getDefaulFicheTableParameters(), permissionSummary);
        }
        nameBuilder.append(".");
        nameBuilder.append(extension);
        TableExportContext tableExportContext = bdfServer.getTableExportContext();
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        SumCellConverter cellConverter = CellConversionInit.subsetTable(bdfServer, extractionContext, subsetTable, tableExportDef).getCellConverter();
        if (extension.equals("csv")) {
            contentType = "text/csv;charset=" + charset;
            StringBuilder buf = new StringBuilder();
            CsvTableWriter csvTableWriter = new CsvTableWriter(subsetTable.getColDefList(), buf, bdfParameters.getUserLangContext());
            switch (tableExportParameters.getHeaderType()) {
                case "columntitle": {
                    csvTableWriter.appendColumnTitleHeader(bdfUser.getWorkingLang(), tableExportContext.getSourceLabelProvider(), subset);
                    break;
                }
                case "columnkey": {
                    csvTableWriter.appendColumnKeyHeader();
                }
            }
            TableExportEngine.exportSubset(subsetTable, csvTableWriter, cellConverter, subsetItems);
            return new TableExportDataSource(nameBuilder.toString(), contentType, charset, buf.toString());
        }
        if (extension.equals("ods")) {
            contentType = "application/vnd.oasis.opendocument.spreadsheet";
            OdsOptions odsOptions = BdfServerUtils.buildOdsOptions(bdfServer, "bdf://this/css/ods/tableexport.css").supplementarySheetWriter(BdfUserUtils.getSupplementarySheetWriter(bdfParameters));
            TableExportOdsParameters tableExportOdsParameters = TableExportOdsParameters.init(tableExportContext, bdfParameters.getUserLangContext()).setSumCellConverter(cellConverter).setHeaderType(tableExportParameters.getHeaderType());
            TableExportOds tableExportOds = TableExportOdsFactory.unique(subsetTable, subsetItems, tableExportOdsParameters, odsOptions);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                tableExportOds.write(outputStream, true);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return new TableExportDataSource(nameBuilder.toString(), contentType, outputStream.toByteArray());
        }
        throw new IllegalArgumentException("Unable to handle this extension: " + extension);
    }
}

