/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.namespaces.BdfSpace;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FicheRetrieveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheRetrieve";
    public static final String COMMANDKEY = "_ CRP-28";
    private FicheMeta ficheMeta;

    public FicheRetrieveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            fichothequeEditor.removeAttribute(this.ficheMeta, BdfSpace.DISCARDTEXT_KEY);
            int ficheid = this.ficheMeta.getId();
            for (Corpus corpus : this.ficheMeta.getCorpus().getSatelliteCorpusList()) {
                FicheMeta satelliteFicheMeta = corpus.getFicheMetaById(ficheid);
                if (satelliteFicheMeta == null) continue;
                fichothequeEditor.removeAttribute(satelliteFicheMeta, BdfSpace.DISCARDTEXT_KEY);
            }
        }
        this.putResultObject("obj.corpus", this.ficheMeta.getCorpus());
        this.putResultObject("obj.fichemeta", this.ficheMeta);
        this.setDone("_ done.corpus.ficheretrieve", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.ficheMeta = this.requestHandler.getMandatoryFicheMeta();
        this.getPermissionChecker().checkWrite(this.ficheMeta);
    }
}

