/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.collation.group;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mapeadores.util.text.collation.CollationUnit;
import net.mapeadores.util.text.collation.group.CollationGroup;
import net.mapeadores.util.text.collation.group.DefaultCollationGroup;
import net.mapeadores.util.text.collation.group.ObjectWrapper;

public class CollationGroupBuilder {
    private final RuleBasedCollator collator;
    private final List<DefaultCollationGroup> groupList = new ArrayList<DefaultCollationGroup>();
    private final Map<Character, DefaultCollationGroup> groupMap = new HashMap<Character, DefaultCollationGroup>();

    public CollationGroupBuilder(Locale locale) {
        char c;
        this.collator = (RuleBasedCollator)Collator.getInstance(locale);
        this.collator.setStrength(0);
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            this.addInitiale(c);
        }
        this.groupList.add(new DefaultCollationGroup('?'));
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.addInitiale(c);
        }
        this.groupList.add(new DefaultCollationGroup('_'));
    }

    private void addInitiale(char c) {
        DefaultCollationGroup collationGroup = new DefaultCollationGroup(c);
        char[] array = new char[]{c};
        String collatedKey = CollationUnit.collate(new String(array), this.collator);
        if (collatedKey.length() > 1) {
            throw new IllegalStateException("should not occur : initiale = " + c);
        }
        this.groupMap.put(Character.valueOf(collatedKey.charAt(0)), collationGroup);
        this.groupList.add(collationGroup);
    }

    public void addObjectWrapper(ObjectWrapper objectWrapper) {
        String string = objectWrapper.getString();
        if (string.length() == 0) {
            this.groupList.get(10).addObject(CollationUnit.collate(objectWrapper.getSourceString(), this.collator), objectWrapper);
        } else {
            String collatedKey = CollationUnit.collate(objectWrapper.getString(), this.collator);
            Character initial = Character.valueOf(collatedKey.charAt(0));
            DefaultCollationGroup collationGroup = this.groupMap.get(initial);
            if (collationGroup == null) {
                collationGroup = this.groupList.get(37);
            }
            collationGroup.addObject(collatedKey, objectWrapper);
        }
    }

    public List<CollationGroup> getCollationGroupList() {
        ArrayList<CollationGroup> result = new ArrayList<CollationGroup>();
        int size = this.groupList.size();
        for (int i = 0; i < size; ++i) {
            DefaultCollationGroup collationGroup = this.groupList.get(i);
            if (collationGroup.isEmpty()) continue;
            result.add(collationGroup);
        }
        return result;
    }
}

