/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets;

import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;

public class HttpAccessException
extends RuntimeException {
    private final int httpType;
    private final CommandMessage commandMessage;
    private String messageText;

    public HttpAccessException(int httpType) {
        this.httpType = httpType;
        this.commandMessage = null;
        this.messageText = null;
    }

    public HttpAccessException(int httpType, CommandMessage commandMessage) {
        this.httpType = httpType;
        this.commandMessage = commandMessage;
        this.messageText = null;
    }

    public HttpAccessException(int httpType, String messageText) {
        this.httpType = httpType;
        this.commandMessage = null;
        this.messageText = messageText;
    }

    public int getHttpType() {
        return this.httpType;
    }

    @Override
    public String getMessage() {
        if (this.messageText != null) {
            return this.messageText;
        }
        if (this.commandMessage != null) {
            return this.commandMessage.getMessageKey();
        }
        return null;
    }

    public CommandMessage getCommandMessage() {
        return this.commandMessage;
    }

    public boolean isUnresolvedMessage() {
        return this.commandMessage != null && this.messageText == null;
    }

    public void resolveMessage(MessageLocalisation messageLocalisation) {
        this.messageText = messageLocalisation.toString(this.commandMessage);
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }
}

