/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.SupplementaryParameter;

public class AppendableRequestMap
implements RequestMap {
    private final RequestMap requestMap;
    private final Set<String> parameterNameSet = new HashSet<String>();
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();

    public AppendableRequestMap(RequestMap requestMap) {
        this.requestMap = requestMap;
        this.parameterNameSet.addAll(requestMap.getParameterNameSet());
    }

    @Override
    public FileValue getFileValue(String name) {
        return this.requestMap.getFileValue(name);
    }

    @Override
    public FileValue[] getFileValues(String name) {
        return this.requestMap.getFileValues(name);
    }

    @Override
    public String getParameter(String name) {
        Object obj = this.parameterMap.get(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                String[] array = (String[])obj;
                return array[0];
            }
        }
        return this.requestMap.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        Object obj = this.parameterMap.get(name);
        if (obj != null) {
            if (obj instanceof String) {
                String[] result = new String[]{(String)obj};
                return result;
            }
            if (obj instanceof String[]) {
                return (String[])obj;
            }
        }
        return this.requestMap.getParameterValues(name);
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.parameterNameSet;
    }

    @Override
    public Locale[] getAcceptableLocaleArray() {
        return this.requestMap.getAcceptableLocaleArray();
    }

    @Override
    public Object getSourceObject() {
        return this.requestMap.getSourceObject();
    }

    public void addSupplementaryParameters(Collection<SupplementaryParameter> supplementaryParameters) {
        for (SupplementaryParameter supplementaryParameter : supplementaryParameters) {
            this.addSupplementaryParameter(supplementaryParameter);
        }
    }

    public void addSupplementaryParameter(SupplementaryParameter supplementaryParameter) {
        boolean isArray = supplementaryParameter.isArray();
        String name = supplementaryParameter.getName();
        if (supplementaryParameter.appendToExisting()) {
            if (isArray) {
                this.appendParameterValues(name, supplementaryParameter.getValueArray());
            } else {
                this.appendParameter(name, supplementaryParameter.getValue());
            }
        } else if (isArray) {
            this.setParameterValues(name, supplementaryParameter.getValueArray());
        } else {
            this.setParameter(name, supplementaryParameter.getValue());
        }
    }

    public void appendParameter(String paramName, String paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName is null");
        }
        if (paramValue == null) {
            throw new IllegalArgumentException("paramValue is null");
        }
        if (!this.parameterNameSet.contains(paramName)) {
            this.setParameter(paramName, paramValue);
        } else {
            String[] valueArray = this.getParameterValues(paramName);
            int length = valueArray.length;
            String[] newArray = new String[length + 1];
            System.arraycopy(valueArray, 0, newArray, 0, length);
            newArray[length] = paramValue;
            this.parameterMap.put(paramName, newArray);
        }
    }

    public void appendParameterValues(String paramName, String[] paramValues) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName is null");
        }
        if (paramValues == null) {
            throw new IllegalArgumentException("paramValues is null");
        }
        if (!this.parameterNameSet.contains(paramName)) {
            this.setParameterValues(paramName, paramValues);
        } else {
            String[] valueArray = this.getParameterValues(paramName);
            int length1 = valueArray.length;
            int length2 = paramValues.length;
            String[] newArray = new String[length1 + length2];
            System.arraycopy(valueArray, 0, newArray, 0, length1);
            System.arraycopy(valueArray, 0, newArray, length1, length2);
            this.parameterMap.put(paramName, newArray);
        }
    }

    public void setParameter(String paramName, String paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName is null");
        }
        if (paramValue == null) {
            throw new IllegalArgumentException("paramValue is null");
        }
        this.parameterNameSet.add(paramName);
        this.parameterMap.put(paramName, paramValue);
    }

    public void setParameterValues(String paramName, String[] paramValues) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName is null");
        }
        if (paramValues == null) {
            throw new IllegalArgumentException("paramValues is null");
        }
        this.parameterNameSet.add(paramName);
        this.parameterMap.put(paramName, paramValues);
    }
}

