/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.io.Serializable;

public final class Range
implements Comparable<Range>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAXIMUM = Integer.MAX_VALUE;
    public static final int MINIMUM = -1;
    private final int min;
    private final int max;

    public Range(int min, int max) {
        if (max < min) {
            this.max = min;
            this.min = max;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int length() {
        return this.max - this.min + 1;
    }

    public Range headRange(int newMax) {
        if (newMax < this.min) {
            return null;
        }
        if (newMax >= this.max) {
            return this;
        }
        return new Range(this.min, newMax);
    }

    public Range headRange(Range Range2) {
        return this.headRange(Range2.max - 1);
    }

    public Range tailRange(int newMin) {
        if (newMin > this.max) {
            return null;
        }
        if (newMin <= this.min) {
            return this;
        }
        return new Range(newMin, this.max);
    }

    public Range tailRange(Range Range2) {
        return this.tailRange(Range2.min + 1);
    }

    public boolean intersects(Range Range2) {
        if (this.max < Range2.min) {
            return false;
        }
        return this.min <= Range2.max;
    }

    public boolean isNeighbour(Range range) {
        if (this.max == range.min - 1) {
            return true;
        }
        return this.min == range.max + 1;
    }

    public Range intersection(Range range) {
        if (!this.intersects(range)) {
            return null;
        }
        return new Range(Math.max(this.min, range.min), Math.min(this.max, range.max));
    }

    public Range union(Range range) {
        return new Range(Math.min(this.min, range.min), Math.max(this.max, range.max));
    }

    public boolean contains(Range Range2) {
        return this.min <= Range2.min && this.max >= Range2.max;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public int hashCode() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Range)) {
            return false;
        }
        Range Range2 = (Range)obj;
        return Range2.max == this.max && Range2.min == this.min;
    }

    public String toString() {
        if (this.min == this.max) {
            return String.valueOf(this.min);
        }
        return this.min + "-" + this.max;
    }

    @Override
    public int compareTo(Range other) {
        if (this.min < other.min) {
            return -1;
        }
        if (this.min > other.min) {
            return 1;
        }
        if (this.max < other.max) {
            return -1;
        }
        if (this.max > other.max) {
            return 1;
        }
        return 0;
    }
}

