/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

public final class FileLength {
    public static final short KB_ROUND = 1;
    public static final short MB_ROUND = 2;
    public static final FileLength EMPTY_FILELENGTH = new FileLength(0L);
    float roundedValue = 0.0f;
    short roundType = 1;
    long filelength;

    public FileLength(long filelength) {
        if (filelength < 0L) {
            throw new IllegalArgumentException("fileLength < 0");
        }
        this.filelength = filelength;
        this.initRound(filelength);
    }

    public long getValue() {
        return this.filelength;
    }

    public float getRoundedValue() {
        return this.roundedValue;
    }

    public short getRoundType() {
        return this.roundType;
    }

    private void initRound(long l) {
        if (l == 0L) {
            return;
        }
        float f = (float)l / 1024.0f;
        float f2 = this.arrondit(f);
        if (f2 != -1.0f) {
            this.roundedValue = f2;
        } else {
            this.roundType = (short)2;
            float f3 = this.arrondit(f /= 1024.0f);
            this.roundedValue = f3 != -1.0f ? f3 : (float)Math.round(f3);
        }
    }

    float arrondit(float f) {
        if (f < 10.0f) {
            if ((f = (float)Math.round(f * 10.0f) / 10.0f) == 0.0f) {
                f = 0.1f;
            }
            return f;
        }
        if (f < 100.0f) {
            f = Math.round(f);
            return f;
        }
        if (f < 1000.0f) {
            f = (float)Math.round(f / 10.0f) * 10.0f;
            return f;
        }
        return -1.0f;
    }
}

