/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.money;

import java.text.DecimalFormatSymbols;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.text.StringUtils;

public class MoneyUtils {
    public static final MoneyConversion SAME_MONEYCONVERSION = new SameMoneyConversion();
    private static final Decimal UN = new Decimal(1L, 0, 0);
    private static final Decimal PETIT = new Decimal(0L, 4, 1);

    private MoneyUtils() {
    }

    public static String[] splitMoney(String s) {
        char firstChar = s.charAt(0);
        if (MoneyUtils.isDigitOrMinus(firstChar)) {
            return MoneyUtils.splitCurrencyAtEnd(s);
        }
        return MoneyUtils.splitCurrencyAtFirst(s);
    }

    private static String[] splitCurrencyAtEnd(String s) {
        int index = -1;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (!MoneyUtils.isDigit(c)) continue;
            index = i;
            break;
        }
        if (index == -1 || index == s.length() - 1) {
            return null;
        }
        String[] result = new String[]{s.substring(0, index + 1).trim(), s.substring(index + 1).trim()};
        return result;
    }

    private static String[] splitCurrencyAtFirst(String s) {
        int index = -1;
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!MoneyUtils.isDigitOrMinus(c)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        String[] result = new String[]{s.substring(index), s.substring(0, index).trim()};
        return result;
    }

    private static boolean isDigitOrMinus(char carac) {
        if (carac == '-') {
            return true;
        }
        return MoneyUtils.isDigit(carac);
    }

    private static boolean isDigit(char carac) {
        if (carac > '9') {
            return false;
        }
        return carac >= '0';
    }

    public static MoneyConversion toMoneyConversion(ExtendedCurrency pivotCurrency, ExtendedCurrency otherCurrency, Decimal decimal) {
        return new DefaultMoneyConversion(pivotCurrency, otherCurrency, decimal);
    }

    public static Decimal getConversionRate(ExtendedCurrency otherCurrency, long otherMoneyLong, ExtendedCurrency pivotCurrency, long pivotMoneyLong) {
        double otherDouble;
        int otherMultiplicator = MoneyUtils.toMultiplicator(otherCurrency.getDefaultFractionDigits());
        int pivotMultiplicator = MoneyUtils.toMultiplicator(pivotCurrency.getDefaultFractionDigits());
        double pivotDouble = (double)pivotMoneyLong / (double)pivotMultiplicator;
        double taux = pivotDouble / (otherDouble = (double)otherMoneyLong / (double)otherMultiplicator);
        long tauxLong = (long)(taux * 100000.0);
        if (tauxLong < 0L) {
            tauxLong = -tauxLong;
        }
        if (tauxLong == 0L) {
            return PETIT;
        }
        String tauxString = Long.toString(tauxLong);
        int length = tauxString.length();
        if (length > 5) {
            try {
                return StringUtils.parseDecimal(tauxString.substring(0, length - 5), tauxString.substring(length - 5));
            }
            catch (NumberFormatException nfe) {
                throw new ShouldNotOccurException(nfe);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 5 - length; ++i) {
            buf.append('0');
        }
        buf.append(tauxString);
        try {
            return StringUtils.parseDecimal("0", buf.toString());
        }
        catch (NumberFormatException nfe) {
            throw new ShouldNotOccurException(nfe);
        }
    }

    public static int toMultiplicator(int fractionDigits) {
        int result = 1;
        for (int i = 0; i < fractionDigits; ++i) {
            result *= 10;
        }
        return result;
    }

    public static String toLitteralString(long moneyLong, ExtendedCurrency currency, DecimalFormatSymbols symbols, boolean avoidDecimal) {
        String litteral = MoneyLong.toString(moneyLong, currency.getDefaultFractionDigits(), symbols.getDecimalSeparator(), symbols.getGroupingSeparator(), avoidDecimal);
        return MoneyUtils.toLitteral(litteral, currency);
    }

    public static String toLitteralString(Decimal decimal, ExtendedCurrency currency, DecimalFormatSymbols symbols) {
        String litteral = decimal.toString(symbols.getDecimalSeparator(), symbols.getGroupingSeparator());
        return MoneyUtils.toLitteral(litteral, currency);
    }

    private static String toLitteral(String litteral, ExtendedCurrency currency) {
        litteral = currency.isSymbolBefore() ? currency.getSymbol() + litteral : litteral + " " + currency.getSymbol();
        litteral = litteral.replace(' ', '\u00a0');
        return litteral;
    }

    private static class DefaultMoneyConversion
    implements MoneyConversion {
        private final int pivotMultiplicator;
        private final int otherMultiplicator;
        private final Decimal conversionRate;
        private final double taux;

        private DefaultMoneyConversion(ExtendedCurrency pivotCurrency, ExtendedCurrency otherCurrency, Decimal conversionRate) {
            this.pivotMultiplicator = MoneyUtils.toMultiplicator(pivotCurrency.getDefaultFractionDigits());
            this.otherMultiplicator = MoneyUtils.toMultiplicator(otherCurrency.getDefaultFractionDigits());
            this.conversionRate = conversionRate;
            this.taux = conversionRate.toDouble();
        }

        @Override
        public Decimal getConversionRate() {
            return this.conversionRate;
        }

        @Override
        public long convertFromPivot(long pivotMoneyLong) {
            boolean opposite = false;
            if (pivotMoneyLong < 0L) {
                opposite = true;
                pivotMoneyLong = -pivotMoneyLong;
            }
            double pivotDouble = (double)pivotMoneyLong / (double)this.pivotMultiplicator;
            double otherDouble = pivotDouble / this.taux;
            long lg = Math.round(otherDouble *= (double)this.otherMultiplicator);
            if (opposite) {
                lg = -lg;
            }
            return lg;
        }

        @Override
        public long convertToPivot(long otherMoneyLong) {
            boolean opposite = false;
            if (otherMoneyLong < 0L) {
                opposite = true;
                otherMoneyLong = -otherMoneyLong;
            }
            double otherDouble = (double)otherMoneyLong / (double)this.otherMultiplicator;
            double pivotDouble = otherDouble * this.taux;
            long lg = Math.round(pivotDouble *= (double)this.pivotMultiplicator);
            if (opposite) {
                lg = -lg;
            }
            return lg;
        }
    }

    private static class SameMoneyConversion
    implements MoneyConversion {
        private SameMoneyConversion() {
        }

        @Override
        public long convertFromPivot(long pivotMoneyLong) {
            return pivotMoneyLong;
        }

        @Override
        public long convertToPivot(long otherMoneyLong) {
            return otherMoneyLong;
        }

        @Override
        public Decimal getConversionRate() {
            return UN;
        }
    }
}

