/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.models;

public interface PersonCore {
    public String getSurname();

    public String getForename();

    public String getNonlatin();

    public boolean isSurnameFirst();

    default public String getLatin() {
        String surname = this.getSurname();
        String forename = this.getForename();
        boolean surnameFirst = this.isSurnameFirst();
        if (forename.length() == 0) {
            if (surname.length() == 0) {
                return "";
            }
            return surname;
        }
        if (surname.length() == 0) {
            return forename;
        }
        if (surnameFirst) {
            return surname + " " + forename;
        }
        return forename + " " + surname;
    }

    default public String toStandardStyle() {
        String nonlatin = this.getNonlatin();
        String latin = this.getLatin();
        if (nonlatin.length() == 0) {
            return latin;
        }
        if (latin.length() == 0) {
            return nonlatin;
        }
        return nonlatin + " (" + latin + ")";
    }

    default public String toDirectoryStyle(boolean uppercase) {
        String surname = this.getSurname();
        String forename = this.getForename();
        String nonlatin = this.getNonlatin();
        StringBuilder buf = new StringBuilder();
        if (uppercase) {
            buf.append(surname.toUpperCase());
        } else {
            buf.append(surname);
        }
        if (forename.length() > 0) {
            buf.append(" ");
            buf.append(forename);
        }
        if (nonlatin.length() > 0) {
            buf.append(" (");
            buf.append(nonlatin);
            buf.append(")");
        }
        return buf.toString();
    }

    default public String toBiblioStyle(boolean uppercase) {
        String surname = this.getSurname();
        String forename = this.getForename();
        String nonlatin = this.getNonlatin();
        StringBuilder buf = new StringBuilder();
        if (uppercase) {
            buf.append(surname.toUpperCase());
        } else {
            buf.append(surname);
        }
        if (forename.length() > 0) {
            buf.append(", ");
            buf.append(forename);
        }
        if (nonlatin.length() > 0) {
            buf.append(" (");
            buf.append(nonlatin);
            buf.append(")");
        }
        return buf.toString();
    }
}

