/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamProducer;

public class TextStreamProducer
implements StreamProducer {
    private final String text;
    private final String charset;
    private final String fileName;

    public TextStreamProducer(String text) {
        this(text, null, "UTF-8");
    }

    public TextStreamProducer(String text, String fileName) {
        this(text, fileName, "UTF-8");
    }

    public TextStreamProducer(String text, String fileName, String charset) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.text = text;
        this.fileName = fileName;
        this.charset = charset;
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        IOUtils.copy(new StringReader(this.text), outputStream, this.charset);
    }
}

