/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html.jsoup;

import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.html.TrustedHtml;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;

public final class HtmlCleaners {
    public static final HtmlCleaner WELLFORMED = new WellformedTrustedHtmlFactory();
    public static final HtmlCleaner TEXT_ONLY = new TextOnlyHtmlCleaner();
    public static final HtmlCleaner SIMPLE_TEXT = new SafelistHtmlCleaner(Safelist.simpleText());
    public static final HtmlCleaner BASIC = new SafelistHtmlCleaner(Safelist.basic());
    public static final HtmlCleaner BASIC_WITH_IMAGES = new SafelistHtmlCleaner(Safelist.basicWithImages());
    public static final HtmlCleaner RELAXED = new SafelistHtmlCleaner(Safelist.relaxed());
    public static final HtmlCleaner EXTENDED = new SafelistHtmlCleaner(HtmlCleaners.extended());
    public static final HtmlCleaner EXTENDED_WITH_STYLE = new SafelistHtmlCleaner(HtmlCleaners.extendedWithStyle());
    public static final HtmlCleaner EXTENDED_WITH_DATA = new SafelistHtmlCleaner(HtmlCleaners.extendedWithStyle());
    public static final HtmlCleaner IMPORTATION = new SafelistHtmlCleaner(HtmlCleaners.importation());

    private HtmlCleaners() {
    }

    public static String textOnly(String html) {
        return TEXT_ONLY.cleanHtml(html).toString();
    }

    public static Safelist extended() {
        return Safelist.relaxed().addTags(new String[]{"hr", "iframe", "video", "audio", "source"}).addAttributes("iframe", new String[]{"src", "name", "allowfullscreen", "height", "width", "frameborder", "scrolling", "marginwidth", "marginheight"}).addAttributes("video", new String[]{"src", "crossorigin", "poster", "preload", "autoplay", "mediagroup", "loop", "muted", "controls", "height", "width"}).addAttributes("audio", new String[]{"src", "crossorigin", "preload", "autoplay", "mediagroup", "loop", "controls"}).addAttributes("source", new String[]{"src", "type"}).addAttributes("a", new String[]{"target", "rel"}).addProtocols("iframe", "src", new String[]{"http", "https"}).addProtocols("video", "src", new String[]{"http", "https"}).addProtocols("audio", "src", new String[]{"http", "https"}).addProtocols("source", "src", new String[]{"http", "https"}).addAttributes(":all", new String[]{"id", "class", "lang"}).addAttributes(":all", new String[]{"id", "class", "lang"});
    }

    public static Safelist extendedWithStyle() {
        return HtmlCleaners.extended().addAttributes(":all", new String[]{"style"});
    }

    public static Safelist importation() {
        return HtmlCleaners.extendedWithStyle().addAttributes(":all", new String[]{"data-bdf-type", "data-bdf-ref"});
    }

    private static class WellformedTrustedHtmlFactory
    implements HtmlCleaner {
        private WellformedTrustedHtmlFactory() {
        }

        @Override
        public TrustedHtml cleanHtml(String html) {
            Document doc = Jsoup.parseBodyFragment((String)html);
            return new TrustedHtml(doc.body().html());
        }
    }

    private static class TextOnlyHtmlCleaner
    implements HtmlCleaner {
        private TextOnlyHtmlCleaner() {
        }

        @Override
        public TrustedHtml cleanHtml(String html) {
            Cleaner cleaner = new Cleaner(Safelist.none());
            return new TrustedHtml(cleaner.clean(Jsoup.parse((String)html)).text());
        }
    }

    private static class SafelistHtmlCleaner
    implements HtmlCleaner {
        private final Safelist safeList;

        private SafelistHtmlCleaner(Safelist safelist) {
            this.safeList = safelist;
        }

        @Override
        public TrustedHtml cleanHtml(String html) {
            return new TrustedHtml(Jsoup.clean((String)html, (Safelist)this.safeList));
        }
    }
}

