/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mapeadores.util.exec.ArgsDefBuilder;
import net.mapeadores.util.exec.CommandDefBuilder;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class ArgsDefDOMReader {
    private final ArgsDefBuilder argsDefBuilder;

    public ArgsDefDOMReader(ArgsDefBuilder argsDefBuilder) {
        this.argsDefBuilder = argsDefBuilder;
    }

    public void readArgs(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
    }

    public static void read(ArgsDefBuilder argsDefBuilder, Element rootElement) {
        ArgsDefDOMReader reader = new ArgsDefDOMReader(argsDefBuilder);
        reader.readArgs(rootElement);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String name;
            String tagName = element.getTagName();
            if (tagName.equals("parameter")) {
                String charValue = element.getAttribute("char");
                if (charValue.length() > 0) {
                    char letter = charValue.charAt(0);
                    String titleLocKey = element.getAttribute("lockey");
                    String valueState = element.getAttribute("value");
                    if (valueState.equals("require")) {
                        ArgsDefDOMReader.this.argsDefBuilder.addParameter(letter, titleLocKey, true);
                    } else if (valueState.equals("list")) {
                        ArrayList<String> valueList = new ArrayList<String>();
                        DOMUtils.readChildren(element, new ValueListConsumer(valueList));
                        ArgsDefDOMReader.this.argsDefBuilder.addParameter(letter, titleLocKey, valueList);
                    } else {
                        ArgsDefDOMReader.this.argsDefBuilder.addParameter(letter, titleLocKey, false);
                    }
                }
            } else if (tagName.equals("command") && (name = element.getAttribute("name")).length() > 0) {
                CommandDefBuilder commandDefBuilder = CommandDefBuilder.init(name).setTitleLocKey(element.getAttribute("lockey"));
                DOMUtils.readChildren(element, new CommandConsumer(commandDefBuilder));
                ArgsDefDOMReader.this.argsDefBuilder.addCommandDef(commandDefBuilder.toCommandDef());
            }
        }
    }

    private static class CommandConsumer
    implements Consumer<Element> {
        private final CommandDefBuilder commandDefBuilder;

        private CommandConsumer(CommandDefBuilder commandDefBuilder) {
            this.commandDefBuilder = commandDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("mandatory")) {
                this.addUserParameter(element, true);
            } else if (tagName.equals("optional")) {
                this.addUserParameter(element, false);
            }
        }

        private void addUserParameter(Element element, boolean mandatory) {
            String value = DOMUtils.readSimpleElement(element);
            if (value.length() > 0) {
                this.commandDefBuilder.addUsedParameter(value.charAt(0), mandatory);
            }
        }
    }

    private static class ValueListConsumer
    implements Consumer<Element> {
        private final List<String> valueList;

        private ValueListConsumer(List<String> valueList) {
            this.valueList = valueList;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("value")) {
                this.valueList.add(element.getAttribute("name"));
            }
        }
    }
}

