/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import java.io.IOException;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class DateStyleXMLPart
extends XMLPart {
    public DateStyleXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void writeFromJavaPattern(String dataStyleName, String pattern) throws IOException {
        this.startOpenTag("number:date-style").addAttribute("style:name", dataStyleName).endOpenTag();
        Parser parser = new Parser();
        parser.parsePattern(pattern);
        this.closeTag("number:date-style");
    }

    private class Parser {
        private StringBuilder litteralBuffer = new StringBuilder();

        private Parser() {
        }

        private void parsePattern(String pattern) throws IOException {
            for (int pos = 0; pos < pattern.length(); ++pos) {
                int start;
                char cur = pattern.charAt(pos);
                if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z') {
                    start = pos++;
                    while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                        ++pos;
                    }
                    int count = pos - start;
                    if (cur == 'p') {
                        int pad = 0;
                        if (pos < pattern.length() && ((cur = pattern.charAt(pos)) >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z')) {
                            pad = count;
                            start = pos++;
                            while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                                ++pos;
                            }
                            count = pos - start;
                        }
                        if (pad == 0) {
                            throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + pattern);
                        }
                        this.padNext(pad);
                    }
                    switch (cur) {
                        case 'y': {
                            this.writeYear(count);
                            break;
                        }
                        case 'L': 
                        case 'M': {
                            this.writeMonth(count);
                            break;
                        }
                        case 'd': {
                            this.writeDayOfMonth(count);
                            break;
                        }
                        case 'E': 
                        case 'c': 
                        case 'e': {
                            this.writeDayOfWeek(count);
                            break;
                        }
                        default: {
                            this.appendLiteral(cur);
                        }
                    }
                    --pos;
                    continue;
                }
                if (cur == '\'') {
                    start = pos++;
                    while (pos < pattern.length()) {
                        if (pattern.charAt(pos) == '\'') {
                            if (pos + 1 >= pattern.length() || pattern.charAt(pos + 1) != '\'') break;
                            ++pos;
                        }
                        ++pos;
                    }
                    if (pos >= pattern.length()) {
                        throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + pattern);
                    }
                    String str = pattern.substring(start + 1, pos);
                    if (str.length() == 0) {
                        this.appendLiteral('\'');
                        continue;
                    }
                    this.appendLiteral(str.replace("''", "'"));
                    continue;
                }
                this.appendLiteral(cur);
            }
            this.flush();
        }

        private void appendLiteral(char c) {
            this.litteralBuffer.append(c);
        }

        private void appendLiteral(String s) {
            this.litteralBuffer.append(s);
        }

        private void padNext(int pad) {
            for (int i = 0; i < pad; ++i) {
                this.litteralBuffer.append(' ');
            }
        }

        private void writeYear(int count) throws IOException {
            this.flush();
            DateStyleXMLPart.this.startOpenTag("number:year");
            if (count != 2) {
                DateStyleXMLPart.this.addAttribute("number:style", "long");
            }
            DateStyleXMLPart.this.closeEmptyTag();
        }

        private void writeMonth(int count) throws IOException {
            this.flush();
            DateStyleXMLPart.this.startOpenTag("number:month");
            if (count == 2 || count == 4) {
                DateStyleXMLPart.this.addAttribute("number:style", "long");
            }
            if (count > 2) {
                DateStyleXMLPart.this.addAttribute("number:textual", "true");
            }
            DateStyleXMLPart.this.closeEmptyTag();
        }

        private void writeDayOfMonth(int count) throws IOException {
            this.flush();
            DateStyleXMLPart.this.startOpenTag("number:day");
            if (count > 1) {
                DateStyleXMLPart.this.addAttribute("number:style", "long");
            }
            DateStyleXMLPart.this.closeEmptyTag();
        }

        private void writeDayOfWeek(int count) throws IOException {
            this.flush();
            DateStyleXMLPart.this.startOpenTag("number:day-of-week");
            if (count == 4) {
                DateStyleXMLPart.this.addAttribute("number:style", "long");
            }
            DateStyleXMLPart.this.closeEmptyTag();
        }

        private void flush() throws IOException {
            if (this.litteralBuffer.length() > 0) {
                DateStyleXMLPart.this.addSimpleElement("number:text", this.litteralBuffer.toString());
                this.litteralBuffer = new StringBuilder();
            }
        }
    }
}

