/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.selection.IllustrationCondition;

public class IllustrationConditionBuilder {
    private final List<IllustrationCondition.Entry> entryList = new ArrayList<IllustrationCondition.Entry>();
    private String logicalOperator = "and";

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public IllustrationConditionBuilder setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
        return this;
    }

    public IllustrationConditionBuilder addEntry(IllustrationCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        this.entryList.add(entry);
        return this;
    }

    public IllustrationCondition toIllustrationCondition() {
        EntryList finalEntryList = new EntryList(this.entryList.toArray(new IllustrationCondition.Entry[this.entryList.size()]));
        return new InternalIllustrationCondition(this.logicalOperator, finalEntryList);
    }

    public static IllustrationConditionBuilder init() {
        return new IllustrationConditionBuilder();
    }

    private static class EntryList
    extends AbstractList<IllustrationCondition.Entry>
    implements RandomAccess {
        private final IllustrationCondition.Entry[] array;

        private EntryList(IllustrationCondition.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public IllustrationCondition.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalIllustrationCondition
    implements IllustrationCondition {
        private final String logicalOperator;
        private final List<IllustrationCondition.Entry> entryList;

        private InternalIllustrationCondition(String logicalOperator, List<IllustrationCondition.Entry> entryList) {
            this.logicalOperator = logicalOperator;
            this.entryList = entryList;
        }

        @Override
        public String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public List<IllustrationCondition.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

