/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.reponderation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Liaison;
import net.fichotheque.junction.Tie;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.reponderation.ReponderationLog;
import net.fichotheque.tools.reponderation.ReponderationParameters;
import net.fichotheque.utils.JunctionUtils;

public final class ReponderationEngine {
    private final ReponderationLog reponderationLog;
    private final Fichotheque fichotheque;
    private final ReponderationParameters reponderationParameters;
    private final FichothequeEditor fichothequeEditor;

    private ReponderationEngine(ReponderationParameters reponderationParameters, FichothequeEditor fichothequeEditor) {
        this.reponderationLog = new ReponderationLog(reponderationParameters);
        this.fichothequeEditor = fichothequeEditor;
        this.fichotheque = fichothequeEditor.getFichotheque();
        this.reponderationParameters = reponderationParameters;
    }

    private ReponderationEngine(ReponderationParameters reponderationParameters, Fichotheque fichotheque) {
        this.reponderationLog = new ReponderationLog(reponderationParameters);
        this.fichotheque = fichotheque;
        this.reponderationParameters = reponderationParameters;
        this.fichothequeEditor = null;
    }

    public static ReponderationLog run(ReponderationParameters reponderationDef, FichothequeEditor fichothequeEditor) {
        ReponderationEngine reponderationEngine = new ReponderationEngine(reponderationDef, fichothequeEditor);
        reponderationEngine.innerRun(false);
        return reponderationEngine.reponderationLog;
    }

    public static ReponderationLog test(ReponderationParameters reponderationDef, Fichotheque fichotheque) {
        ReponderationEngine reponderationEngine = new ReponderationEngine(reponderationDef, fichotheque);
        reponderationEngine.innerRun(true);
        return reponderationEngine.reponderationLog;
    }

    private void innerRun(boolean test) {
        SubsetKey junctionSubsetKey;
        Subset junctionSubset;
        SubsetKey originSubsetKey = this.reponderationParameters.getOriginSubsetKey();
        Subset origineSubset = this.fichotheque.getSubset(originSubsetKey);
        if (origineSubset == null) {
            this.addError("origin_unknownsubset");
        }
        if ((junctionSubset = this.fichotheque.getSubset(junctionSubsetKey = this.reponderationParameters.getJunctionSubsetKey())) == null) {
            this.addError("junction_unknownsubset");
        }
        if (this.hasError()) {
            return;
        }
        List<SubsetItem> originSubsetItemList = this.getOriginSubsetItemList(origineSubset);
        if (this.hasError()) {
            return;
        }
        if (test) {
            return;
        }
        String oldMode = this.reponderationParameters.getOldMode();
        String newMode = this.reponderationParameters.getNewMode();
        int oldWeight = this.reponderationParameters.getOldWeight();
        int newWeight = this.reponderationParameters.getNewWeight();
        JunctionEditor junctionEditor = this.fichothequeEditor.getJunctionEditor();
        for (SubsetItem originSubsetItem : originSubsetItemList) {
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendOrWeightReplaceEngine(originSubsetItem);
            Collection<Liaison> liaisons = JunctionUtils.filter(this.fichotheque.getJunctions(originSubsetItem, junctionSubset), oldMode);
            boolean done = false;
            for (Liaison liaison : liaisons) {
                int weight = liaison.getTie().getWeight();
                if (oldWeight != -1 && weight != oldWeight) continue;
                if (newWeight != -1) {
                    weight = newWeight;
                }
                SubsetItem subsetItem = liaison.getSubsetItem();
                junctionChangeEngine.addTie(subsetItem, newMode, weight);
                this.addResult(originSubsetItem.getId(), subsetItem.getId());
                done = true;
            }
            if (!done) continue;
            JunctionChanges junctionChanges = junctionChangeEngine.toJunctionChanges();
            if (!oldMode.equals(newMode)) {
                junctionChanges = ReponderationEngine.alter(junctionChanges, oldMode);
            }
            junctionEditor.updateJunctions(originSubsetItem, junctionChanges);
        }
    }

    private List<SubsetItem> getOriginSubsetItemList(Subset origineCorpus) {
        ArrayList<SubsetItem> originSubsetItemList = new ArrayList<SubsetItem>();
        int ficheCount = this.reponderationParameters.getOriginIdCount();
        for (int i = 0; i < ficheCount; ++i) {
            int originSubsetItem = this.reponderationParameters.getOriginId(i);
            SubsetItem subsetItem = origineCorpus.getSubsetItemById(originSubsetItem);
            if (subsetItem == null) {
                this.addIdError("missing_origin_id_error", originSubsetItem);
                continue;
            }
            originSubsetItemList.add(subsetItem);
        }
        return originSubsetItemList;
    }

    private void addError(String errorKey) {
        this.reponderationLog.addErrorKey(errorKey);
    }

    private void addIdError(String errorKey, int id) {
        this.reponderationLog.addIdError(errorKey, id);
    }

    private boolean hasError() {
        return this.reponderationLog.hasError();
    }

    private void addResult(int originId, int junctionId) {
        this.reponderationLog.addResult(originId, junctionId);
    }

    private static JunctionChanges alter(JunctionChanges junctionChanges, String oldMode) {
        ArrayList<JunctionChanges.Entry> alteredList = new ArrayList<JunctionChanges.Entry>();
        for (JunctionChanges.Entry entry : junctionChanges.getEntryList()) {
            alteredList.add(JunctionUtils.toEntry(entry.getSubsetItem(), new WrappedJunctionChange(oldMode, entry.getJunctionChange())));
        }
        return new WrappedJunctionChanges(junctionChanges.getRemovedList(), Collections.unmodifiableList(alteredList));
    }

    private static class WrappedJunctionChange
    implements JunctionChange {
        private final List<String> oldModeList;
        private final JunctionChange junctionChange;

        private WrappedJunctionChange(String oldMode, JunctionChange junctionChange) {
            this.oldModeList = Collections.singletonList(oldMode);
            this.junctionChange = junctionChange;
        }

        @Override
        public List<String> getRemovedModeList() {
            return this.oldModeList;
        }

        @Override
        public List<Tie> getChangedTieList() {
            return this.junctionChange.getChangedTieList();
        }
    }

    private static class WrappedJunctionChanges
    implements JunctionChanges {
        private final List<SubsetItem> removedList;
        private final List<JunctionChanges.Entry> entryList;

        private WrappedJunctionChanges(List<SubsetItem> removedSubsetItemList, List<JunctionChanges.Entry> entryList) {
            this.removedList = removedSubsetItemList;
            this.entryList = entryList;
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return this.removedList;
        }

        @Override
        public List<JunctionChanges.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

