/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.thesaurus;

import java.util.HashSet;
import java.util.Set;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.importation.parsers.handlers.IdalphaHandler;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusColumns;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusRowParser;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.utils.ParentChangeUtils;
import net.mapeadores.util.logging.ErrorMessageException;

class CreationRowParser
extends ThesaurusRowParser {
    private final EditThesaurusImportBuilder editThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final ThesaurusColumns thesaurusColumns;
    private final Set<String> idalphaSet;
    private final Set<Integer> idSet;
    private final ImportationParseContext parseContext;

    private CreationRowParser(EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ThesaurusColumns thesaurusColumns, ImportationParseContext parseContext) {
        this.editThesaurusImportBuilder = editThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.thesaurusColumns = thesaurusColumns;
        this.parseContext = parseContext;
        this.idSet = thesaurusColumns.getIdIndex() != -1 ? new HashSet<Integer>() : null;
        this.idalphaSet = thesaurusColumns.getIdalphaHandler() != null ? new HashSet<String>() : null;
    }

    @Override
    public EditThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.editThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        String statusString;
        Thesaurus thesaurus = this.editThesaurusImportBuilder.getThesaurus();
        int columnCount = row.getColumnCount();
        int idIndex = this.thesaurusColumns.getIdIndex();
        int newId = -1;
        boolean withFatalError = false;
        if (idIndex != -1 && idIndex < columnCount) {
            String idString = row.getColumnValue(idIndex).trim();
            try {
                newId = Integer.parseInt(idString);
                if (newId < 1) {
                    newId = -1;
                } else if (thesaurus.getMotcleById(newId) != null) {
                    this.parseResultBuilder.existingId(rowNumber, idString);
                    newId = -1;
                } else {
                    this.idSet.add(newId);
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.notIntegerId(rowNumber, idString);
            }
        }
        IdalphaHandler idalphaHandler = this.thesaurusColumns.getIdalphaHandler();
        String newIdalpha = null;
        if (idalphaHandler != null) {
            try {
                newIdalpha = idalphaHandler.getIdalpha(row, true);
                if (thesaurus.getMotcleByIdalpha(newIdalpha) != null) {
                    this.parseResultBuilder.existingIdalpha(rowNumber, newIdalpha);
                    withFatalError = true;
                } else {
                    this.idalphaSet.add(newIdalpha);
                }
            }
            catch (ErrorMessageException eme) {
                this.parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
                withFatalError = true;
            }
        }
        ParentChange parentChange = null;
        int parentIdIndex = this.thesaurusColumns.getParentIdIndex();
        IdalphaHandler parentIdalphaHandler = this.thesaurusColumns.getParentIdalphaHandler();
        if (parentIdIndex != -1) {
            String parentIdString;
            if (parentIdIndex < columnCount && (parentIdString = row.getColumnValue(parentIdIndex).trim()).length() > 0) {
                try {
                    int parentId = Integer.parseInt(parentIdString);
                    if (parentId < 1) {
                        parentId = -1;
                    } else if (thesaurus.getMotcleById(parentId) == null && !this.idSet.contains(parentId)) {
                        this.parseResultBuilder.unknownId(rowNumber, parentIdString);
                        parentId = -1;
                    } else if (parentId == newId) {
                        this.parseResultBuilder.selfParent(rowNumber, parentIdString);
                        parentId = -1;
                    }
                    if (parentId > 0) {
                        parentChange = ParentChangeUtils.toIdParentChange(parentId);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.parseResultBuilder.notIntegerId(rowNumber, parentIdString);
                }
            }
        } else if (parentIdalphaHandler != null) {
            try {
                String parentIdalpha = parentIdalphaHandler.getIdalpha(row, false);
                if (parentIdalpha != null) {
                    if (thesaurus.getMotcleByIdalpha(parentIdalpha) == null && !this.idalphaSet.contains(parentIdalpha)) {
                        this.parseResultBuilder.unknownIdalpha(rowNumber, parentIdalpha);
                        parentIdalpha = null;
                    } else if (parentIdalpha.equals(newIdalpha)) {
                        this.parseResultBuilder.selfParent(rowNumber, parentIdalpha);
                        parentIdalpha = null;
                    }
                }
                if (parentIdalpha != null) {
                    parentChange = ParentChangeUtils.toIdalphaParentChange(parentIdalpha);
                }
            }
            catch (ErrorMessageException eme) {
                this.parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
            }
        }
        if (withFatalError) {
            return;
        }
        EditMotcleImportBuilder motcleImportBuilder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(newId, newIdalpha);
        motcleImportBuilder.setParent(parentChange);
        int statusIndex = this.thesaurusColumns.getStatusIndex();
        if (statusIndex != -1 && !(statusString = row.getColumnValue(statusIndex).trim()).isEmpty()) {
            try {
                motcleImportBuilder.setNewStatus(FichothequeConstants.checkMotcleStatus(statusString));
            }
            catch (IllegalArgumentException iae) {
                this.parseResultBuilder.unknownStatus(rowNumber, statusString);
            }
        }
        if (this.thesaurusColumns.hasLabelHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLabelChangeBuilder(), this.thesaurusColumns.getLabelHandlerArray(), row, this.parseResultBuilder, rowNumber);
        }
        if (this.thesaurusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getAttributeChangeBuilder(), this.thesaurusColumns.getAttributeHandlerArray(), row);
        }
        if (this.thesaurusColumns.hasJunctionHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getTiesImportBuilder(), this.thesaurusColumns.getJunctionHandlers(), row, thesaurus, this.parseContext);
        }
    }

    static CreationRowParser newInstance(String[] fieldArray, EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ImportationParseContext parseContext) {
        ThesaurusColumns thesaurusColumns = ThesaurusColumns.parse(fieldArray, editThesaurusImportBuilder, parseResultBuilder);
        if (editThesaurusImportBuilder.getThesaurus().isIdalphaType() && thesaurusColumns.getIdalphaHandler() == null) {
            parseResultBuilder.missingColumn(ThesaurusFieldKey.IDALPHA.toString());
            return null;
        }
        return new CreationRowParser(editThesaurusImportBuilder, parseResultBuilder, thesaurusColumns, parseContext);
    }
}

