/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.tools.importation.parsers.Row;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.text.CleanedString;

public class AttributeHandler {
    private final AttributeKey attributeKey;
    private int uniqueIndex = -1;
    private List<Integer> indexList;

    public AttributeHandler(AttributeKey attributeKey) {
        this.attributeKey = attributeKey;
    }

    public boolean addIndex(int index) {
        if (index == -1) {
            this.uniqueIndex = index;
        } else {
            this.uniqueIndex = -2;
            if (this.indexList == null) {
                this.indexList = new ArrayList<Integer>();
            }
            this.indexList.add(index);
        }
        return true;
    }

    public void handle(Row row, AttributeChangeBuilder attributeChangeBuilder) {
        int columnCount = row.getColumnCount();
        ArrayList<CleanedString> valueList = new ArrayList<CleanedString>();
        if (this.uniqueIndex > -1) {
            if (this.uniqueIndex < columnCount) {
                AttributeParser.parseValues(valueList, row.getColumnValue(this.uniqueIndex));
            }
        } else {
            int indexCount = this.indexList.size();
            for (int i = 0; i < indexCount; ++i) {
                int index = this.indexList.get(i);
                if (index >= columnCount) continue;
                AttributeParser.parseValues(valueList, row.getColumnValue(index));
            }
        }
        if (valueList.isEmpty()) {
            attributeChangeBuilder.putRemovedAttributeKey(this.attributeKey);
        } else {
            attributeChangeBuilder.appendValues(this.attributeKey, valueList);
        }
    }
}

