/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.JunctionUtils;

public class FicheMetaTokenizer
implements Tokenizer {
    private final Corpus corpus;
    private final FicheMetaFormatter ficheMetaFormatter;
    private final String mode;
    private final int weightFilter;
    private final boolean globalSelect;
    private final boolean idSort;

    public FicheMetaTokenizer(Corpus corpus, FicheMetaFormatter ficheMetaFormatter, String mode, int weightFilter, boolean globalSelect, boolean idSort) {
        this.corpus = corpus;
        this.ficheMetaFormatter = ficheMetaFormatter;
        this.mode = mode;
        this.weightFilter = weightFilter;
        this.globalSelect = globalSelect;
        this.idSort = idSort;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        Junctions junctions;
        ArrayList<Liaison> liaisons;
        if (!formatSource.getSubsetAccessPredicate().test(this.corpus)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Predicate<SubsetItem> predicate = null;
        if (this.globalSelect) {
            predicate = formatSource.getGlobalPredicate();
        }
        if ((liaisons = new ArrayList<Liaison>(JunctionUtils.filter(junctions = formatSource.getSubsetItemPointeur().getJunctions(this.corpus), this.mode, this.weightFilter, predicate))).isEmpty()) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        if (this.idSort) {
            Collections.sort(liaisons, Comparators.LIAISONID);
        }
        return new InternalTokens(liaisons, this.ficheMetaFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final List<Liaison> liaisonList;
        private final FicheMetaFormatter ficheMetaFormatter;
        private final FormatSource formatSource;

        private InternalTokens(List<Liaison> liaisonList, FicheMetaFormatter ficheMetaFormatter, FormatSource formatSource) {
            this.liaisonList = liaisonList;
            this.ficheMetaFormatter = ficheMetaFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.liaisonList.size();
        }

        @Override
        public String get(int i) {
            Liaison liaison = this.liaisonList.get(i);
            return this.ficheMetaFormatter.formatFicheMeta((FicheMeta)liaison.getSubsetItem(), liaison.getTie().getWeight(), this.formatSource);
        }
    }
}

