/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.Instructions;
import net.mapeadores.util.instruction.InstructionsParser;
import net.mapeadores.util.xml.XMLWriter;

public class FormulaEngine {
    public static final String CELL_ARGUMENT = "cell";
    public static final String COLUMNSUM_ARGUMENT = "columnsum";
    private final boolean[] isFormulaArray;
    private final String[] valueTypeArray;
    private final Map<String, ColInfo> colMap = new HashMap<String, ColInfo>();
    private final Map<String, Object> instructionMap = new HashMap<String, Object>();
    private final SubsetKey subsetKey;

    public FormulaEngine(SubsetTable subsetTable) {
        this.subsetKey = subsetTable.getSubsetKey();
        List<ColDef> colDefList = subsetTable.getColDefList();
        int colLength = colDefList.size();
        this.isFormulaArray = new boolean[colLength];
        this.valueTypeArray = new String[colLength];
        for (int i = 0; i < colLength; ++i) {
            ColDef colDef = colDefList.get(i);
            String letter = OdXML.toLetter(i + 1);
            this.colMap.put(colDef.getColName(), new ColInfo(colDef, letter));
            if (colDef.isFormula()) {
                this.isFormulaArray[i] = true;
                this.valueTypeArray[i] = this.getType(colDef);
                continue;
            }
            this.isFormulaArray[i] = false;
        }
    }

    public boolean isFormulaColumn(int columnNumber) {
        return this.isFormulaArray[columnNumber - 1];
    }

    public void writeFormulaCell(int rowNumber, int columnNumber, XMLWriter xmlWriter, String s) throws IOException {
        Object obj = this.instructionMap.get(s);
        if (obj == null) {
            obj = this.build(s);
            this.instructionMap.put(s, obj);
        }
        if (obj instanceof String) {
            OdXML.addStringTableCell(xmlWriter, (String)obj);
            return;
        }
        String formula = this.resoveFormula((Object[])obj, rowNumber);
        OdXML.addFormulaTableCell(xmlWriter, formula, this.valueTypeArray[columnNumber - 1], null, 1);
    }

    private String getType(ColDef colDef) {
        switch (colDef.getFormulaCastType()) {
            case "percentage": {
                return "percentage";
            }
            case "money": {
                return "currency";
            }
        }
        return "float";
    }

    private String resoveFormula(Object[] formulaArray, int rowNumber) {
        StringBuilder buf = new StringBuilder();
        buf.append("of:=");
        for (Object obj : formulaArray) {
            if (obj instanceof String) {
                buf.append((String)obj);
                continue;
            }
            if (!(obj instanceof ColInfo)) continue;
            buf.append("[.");
            buf.append(((ColInfo)obj).letter);
            buf.append(rowNumber);
            buf.append("]");
        }
        return buf.toString();
    }

    private Object build(String s) {
        Instructions.Part firstPart;
        Instructions instructions = InstructionsParser.parse(s);
        int partSize = instructions.size();
        if (partSize == 0) {
            return "#Error# empty instruction";
        }
        if (partSize == 1 && (firstPart = (Instructions.Part)instructions.get(0)) instanceof Instructions.LiteralPart) {
            return ((Instructions.LiteralPart)firstPart).getText();
        }
        Object[] partArray = new Object[partSize];
        String error = null;
        for (int i = 0; i < partSize; ++i) {
            Instructions.Part part = (Instructions.Part)instructions.get(i);
            if (part instanceof Instructions.LiteralPart) {
                partArray[i] = ((Instructions.LiteralPart)part).getText();
                continue;
            }
            Instruction instruction = ((Instructions.InstructionPart)part).getInstruction();
            String argumentKey = ((Argument)instruction.get(0)).getKey();
            String argumentValue = ((Argument)instruction.get(0)).getValue();
            if (argumentKey.equals(CELL_ARGUMENT)) {
                ColInfo colInfo = this.colMap.get(argumentValue);
                if (colInfo == null) {
                    error = "#Error# unknown column: " + argumentValue;
                    break;
                }
                partArray[i] = colInfo;
                continue;
            }
            if (argumentKey.equals(COLUMNSUM_ARGUMENT)) {
                String columnSum = this.checkColumnSum(argumentValue);
                if (columnSum == null) {
                    error = "#Error# unknown columnsum: " + argumentValue;
                    break;
                }
                partArray[i] = columnSum;
                continue;
            }
            error = "#Error# unknown argument: " + argumentKey;
            break;
        }
        if (error != null) {
            return error;
        }
        return partArray;
    }

    private String checkColumnSum(String argument) {
        if (argument == null) {
            return null;
        }
        ColInfo colInfo = this.colMap.get(argument);
        if (colInfo == null) {
            return null;
        }
        if (!colInfo.colDef.isWithColumnSum()) {
            return null;
        }
        return "columnsum_" + this.subsetKey + "_" + colInfo.colDef.getColName();
    }

    private static class ColInfo {
        private final ColDef colDef;
        private final String letter;

        private ColInfo(ColDef colDef, String letter) {
            this.colDef = colDef;
            this.letter = letter;
        }
    }
}

