/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class RedacteurDOMReader {
    private final SphereEditor sphereEditor;
    private final MessageHandler messageHandler;
    private final RootConsumer rootConsumer = new RootConsumer();

    public RedacteurDOMReader(SphereEditor sphereEditor, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.sphereEditor = sphereEditor;
    }

    public void fillRedacteur(Redacteur redacteur, Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        this.rootConsumer.setRedacteur(redacteur, attributesBuilder);
        DOMUtils.readChildren(element, this.rootConsumer);
        this.sphereEditor.getFichothequeEditor().putAttributes(redacteur, attributesBuilder.toAttributes());
    }

    private static PersonCore toPersonCore(Element element) {
        String nonlatin;
        String forename;
        String surname = element.getAttribute("surname");
        if (surname.length() == 0) {
            surname = element.getAttribute("nom");
        }
        if ((forename = element.getAttribute("forename")).length() == 0) {
            forename = element.getAttribute("prenom");
        }
        if ((nonlatin = element.getAttribute("nonlatin")).length() == 0) {
            nonlatin = element.getAttribute("original");
        }
        boolean surnameFirst = false;
        String surnameFirstString = element.getAttribute("surname-first");
        if (surnameFirstString.length() == 0) {
            surnameFirstString = element.getAttribute("nom-avant");
        }
        if (surnameFirstString.equals("true")) {
            surnameFirst = true;
        }
        return PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
    }

    private static EmailCore toEmailCore(Element element) throws ParseException {
        String addrSpec = element.getAttribute("addr-spec");
        String realName = element.getAttribute("real-name");
        if (realName.length() == 0) {
            realName = element.getAttribute("nom-complet");
        }
        return EmailCoreUtils.parse(addrSpec, realName);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private Redacteur redacteur;
        private AttributesBuilder attributesBuilder;

        private RootConsumer() {
        }

        private void setRedacteur(Redacteur redacteur, AttributesBuilder attributesBuilder) {
            this.redacteur = redacteur;
            this.attributesBuilder = attributesBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("person-core") || tagName.equals("personne-core") || tagName.equals("personne-bean")) {
                PersonCore personCore = RedacteurDOMReader.toPersonCore(element);
                RedacteurDOMReader.this.sphereEditor.setPerson(this.redacteur, personCore);
            } else if (tagName.equals("email-core") || tagName.equals("courriel-core") || tagName.equals("courriel-bean")) {
                EmailCore emailCore = null;
                try {
                    emailCore = RedacteurDOMReader.toEmailCore(element);
                }
                catch (ParseException iae) {
                    DomMessages.wrongAttributeValue(RedacteurDOMReader.this.messageHandler, tagName, "addr-spec", element.getAttribute("addr-spec"));
                }
                RedacteurDOMReader.this.sphereEditor.setEmail(this.redacteur, emailCore);
            } else if (tagName.equals("attr")) {
                AttributeUtils.readAttrElement(this.attributesBuilder, element, RedacteurDOMReader.this.messageHandler, tagName);
            } else {
                DomMessages.unknownTagWarning(RedacteurDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

