/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.syntax;

import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.TextContent;

public final class FicheblockCodemirror {
    private FicheblockCodemirror() {
    }

    public static void appendFicheBlock(Appendable buf, FicheBlock ficheBlock) throws IOException {
        HtmlWriter writer = new HtmlWriter(buf);
        writer.appendFicheBlock(ficheBlock);
    }

    public static void appendAttsList(Appendable buf, List<Atts> attsList) throws IOException {
        if (attsList != null) {
            HtmlWriter writer = new HtmlWriter(buf);
            writer.appendAttsList(attsList);
        }
    }

    public static void appendTextContent(Appendable buf, TextContent textContent, String supplementaryClasses) throws IOException {
        HtmlWriter writer = new HtmlWriter(buf);
        writer.supplementaryClasses = supplementaryClasses;
        writer.appendTextContent(textContent, true);
    }

    private static boolean needsQuote(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case ' ': 
                case '\"': 
                case ')': 
                case '=': {
                    return true;
                }
            }
        }
        return false;
    }

    private static void escapeString(Appendable buf, String s) throws IOException {
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\u00a0': 
                case '\u202f': {
                    buf.append('~');
                    continue block3;
                }
                default: {
                    FicheblockCodemirror.escapeHtml(buf, carac);
                }
            }
        }
    }

    private static void escapeHtml(Appendable buf, String value) throws IOException {
        int length = value.length();
        block6: for (int i = 0; i < length; ++i) {
            char carac = value.charAt(i);
            switch (carac) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
    }

    private static void escapeHtml(Appendable buf, char carac) throws IOException {
        switch (carac) {
            case '&': {
                buf.append("&amp;");
                break;
            }
            case '\"': {
                buf.append("&quot;");
                break;
            }
            case '<': {
                buf.append("&lt;");
                break;
            }
            case '>': {
                buf.append("&gt;");
                break;
            }
            default: {
                buf.append(carac);
            }
        }
    }

    private static class HtmlWriter {
        private final Appendable buf;
        private String supplementaryClasses = "";

        private HtmlWriter(Appendable appendable) {
            this.buf = appendable;
        }

        private void appendFicheBlock(FicheBlock ficheBlock) throws IOException {
            if (ficheBlock instanceof H) {
                H h = (H)ficheBlock;
                int level = h.getLevel();
                this.supplementaryClasses = " cm-ficheblock-hcontent";
                this.appendParagraphBlockAtts(h.getAtts());
                this.startFirstChars();
                for (int i = 0; i < level; ++i) {
                    this.buf.append("#");
                }
                this.endSpan();
                this.appendTextContent((H)ficheBlock, true);
            } else if (ficheBlock instanceof P) {
                P p = (P)ficheBlock;
                this.appendParagraphBlockAtts(p.getAtts());
                this.appendP(p);
            }
        }

        private void appendP(P p) throws IOException {
            boolean rajout = false;
            switch (p.getType()) {
                case 1: {
                    this.appendFirstChar('>');
                    rajout = true;
                    break;
                }
                case 3: {
                    this.appendFirstChar('?');
                    rajout = true;
                    break;
                }
                case 4: {
                    this.appendFirstChar('!');
                    rajout = true;
                    break;
                }
            }
            String source = p.getSource();
            int sourceLength = source.length();
            if (sourceLength > 0) {
                this.startSourceSpan();
                this.buf.append('@');
                for (int i = 0; i < sourceLength; ++i) {
                    char carac = source.charAt(i);
                    if (carac == '\\' || carac == ':') {
                        this.buf.append('\\');
                    }
                    FicheblockCodemirror.escapeHtml(this.buf, carac);
                }
                this.buf.append(" :");
                rajout = true;
                this.endSpan();
            }
            if (rajout) {
                this.buf.append(' ');
            }
            this.appendTextContent(p, true);
        }

        private void appendAttsList(List<Atts> attsList) throws IOException {
            if (attsList.isEmpty()) {
                return;
            }
            this.appendOperator('[');
            for (Atts atts : attsList) {
                this.appendAttsWithinParenthesis(atts);
            }
            this.appendOperator(']');
            this.buf.append(' ');
        }

        private void appendParagraphBlockAtts(Atts atts) throws IOException {
            if (atts.isEmpty()) {
                return;
            }
            this.appendOperator('[');
            this.appendAttsWithinParenthesis(atts);
            this.appendOperator(']');
            this.buf.append(' ');
        }

        private boolean appendTextContent(TextContent textContent, boolean withSpecialParseChars) throws IOException {
            boolean withSupplementary = this.withSupplementary();
            boolean rajout = false;
            int count = textContent.size();
            for (int i = 0; i < count; ++i) {
                Object obj = textContent.get(i);
                if (obj instanceof String) {
                    if (withSupplementary) {
                        this.startSpanWithSupplementary("");
                    }
                    FicheblockCodemirror.escapeString(this.buf, (String)obj);
                    if (((String)obj).length() > 0) {
                        rajout = true;
                    }
                    if (!withSupplementary) continue;
                    this.endSpan();
                    continue;
                }
                if (!(obj instanceof S)) continue;
                rajout = true;
                this.appendSpan((S)obj, withSpecialParseChars);
            }
            return rajout;
        }

        private void appendAttsWithinParenthesis(Atts atts) throws IOException {
            this.appendOperator('(');
            this.appendAtts(atts, true);
            this.appendOperator(')');
        }

        private void appendAtts(Atts atts, boolean first) throws IOException {
            int attLength = atts.size();
            for (int i = 0; i < attLength; ++i) {
                if (first) {
                    first = false;
                } else {
                    this.buf.append(' ');
                }
                String name = atts.getName(i);
                if (name.equals("class")) {
                    this.appendClassAtt(atts.getValue(i));
                    continue;
                }
                if (name.startsWith("data-")) {
                    this.startAttNameSpan();
                    FicheblockCodemirror.escapeHtml(this.buf, name.substring(4));
                    this.buf.append('=');
                    this.endSpan();
                    this.appendAttValue(atts.getValue(i));
                    continue;
                }
                this.startAttNameSpan();
                FicheblockCodemirror.escapeHtml(this.buf, name);
                this.buf.append('=');
                this.endSpan();
                this.appendAttValue(atts.getValue(i));
            }
        }

        private void appendClassAtt(String value) throws IOException {
            int idx = value.indexOf(45);
            boolean done = false;
            if (idx > 0 && idx < value.length() - 1) {
                String prefix;
                switch (prefix = value.substring(0, idx)) {
                    case "cm": 
                    case "fbe": {
                        this.startAttNameSpan();
                        this.buf.append(prefix);
                        this.buf.append('=');
                        this.endSpan();
                        this.appendAttValue(value.substring(idx + 1));
                        done = true;
                    }
                }
            }
            if (!done) {
                this.startAttNameSpan();
                this.buf.append('c');
                this.buf.append('=');
                this.endSpan();
                this.appendAttValue(value);
            }
        }

        private void appendAttValue(String value) throws IOException {
            this.appendAttValue(this.buf, value, "cm-ficheblock-attvalue");
        }

        private void appendAttValue(Appendable buf, String value, String valueClass) throws IOException {
            if (FicheblockCodemirror.needsQuote(value)) {
                int length = value.length();
                this.startStringSpan();
                buf.append('\"');
                block4: for (int j = 0; j < length; ++j) {
                    char carac = value.charAt(j);
                    switch (carac) {
                        case '\"': {
                            buf.append("\\\"");
                            continue block4;
                        }
                        case '\\': {
                            buf.append("\\\\");
                            continue block4;
                        }
                        default: {
                            FicheblockCodemirror.escapeHtml(buf, carac);
                        }
                    }
                }
                buf.append('\"');
                this.endSpan();
            } else {
                this.startSpan(valueClass);
                FicheblockCodemirror.escapeHtml(buf, value);
                this.endSpan();
            }
        }

        private void appendSpan(S span, boolean specialchars) throws IOException {
            if (!(specialchars && span.getAtts().isEmpty() && span.getRef().isEmpty())) {
                this.appendAttsSpan(span);
            } else {
                switch (span.getType()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        this.appendEmphasisSpan(span);
                        break;
                    }
                    case 20: {
                        this.startOperatorSpan();
                        this.buf.append("[%]");
                        this.endSpan();
                        break;
                    }
                    default: {
                        this.appendAttsSpan(span);
                    }
                }
            }
        }

        private void appendEmphasisSpan(S span) throws IOException {
            int i;
            int num = 1;
            switch (span.getType()) {
                case 1: {
                    num = 1;
                    break;
                }
                case 2: {
                    num = 2;
                    break;
                }
                case 4: {
                    num = 3;
                }
            }
            this.startOperatorSpan();
            for (i = 0; i < num; ++i) {
                this.buf.append('{');
            }
            this.endSpan();
            this.appendTypoSpanValue(span.getValue(), '}');
            this.startOperatorSpan();
            for (i = 0; i < num; ++i) {
                this.buf.append('}');
            }
            this.endSpan();
        }

        private void appendAttsSpan(S span) throws IOException {
            this.appendOperator('[');
            this.startInitialeSpan();
            this.buf.append(span.getTypeInitial());
            this.endSpan();
            Atts atts = span.getAtts();
            String ref = span.getRef();
            if (!ref.isEmpty() || !atts.isEmpty()) {
                this.appendOperator('(');
                boolean first = true;
                if (!ref.isEmpty()) {
                    this.appendAttValue(this.buf, ref, "cm-ficheblock-ref");
                    first = false;
                }
                this.appendAtts(atts, first);
                this.appendOperator(')');
            }
            short spanType = span.getType();
            String value = span.getValue();
            if (S.isRefDefaultValue(spanType)) {
                if (value.isEmpty()) {
                    this.buf.append(' ');
                    value = "-";
                } else if (value.equals(ref)) {
                    value = "";
                } else {
                    this.buf.append(' ');
                }
            } else {
                this.buf.append(' ');
            }
            if (S.isTypoType(spanType)) {
                this.appendTypoSpanValue(value, ']');
            } else {
                this.appendTechSpanValue(value);
            }
            this.appendOperator(']');
        }

        private void appendTypoSpanValue(String value, char closingChar) throws IOException {
            boolean withSupplementary = this.withSupplementary();
            if (withSupplementary) {
                this.startSpanWithSupplementary("");
            }
            int length = value.length();
            block5: for (int i = 0; i < length; ++i) {
                char carac = value.charAt(i);
                if (carac == closingChar) {
                    this.buf.append('\\');
                    this.buf.append(closingChar);
                    continue;
                }
                switch (carac) {
                    case '\u00a0': {
                        this.buf.append('~');
                        continue block5;
                    }
                    case '\u202f': {
                        this.buf.append('~');
                        continue block5;
                    }
                    case '\\': {
                        this.buf.append("\\\\");
                        continue block5;
                    }
                    default: {
                        FicheblockCodemirror.escapeHtml(this.buf, carac);
                    }
                }
            }
            if (withSupplementary) {
                this.endSpan();
            }
        }

        private void appendTechSpanValue(String value) throws IOException {
            this.startSpanWithSupplementary("cm-ficheblock-span-tech");
            int length = value.length();
            block4: for (int i = 0; i < length; ++i) {
                char carac = value.charAt(i);
                switch (carac) {
                    case ']': {
                        this.buf.append('\\');
                        this.buf.append(']');
                        continue block4;
                    }
                    case '\\': {
                        this.buf.append("\\\\");
                        continue block4;
                    }
                    default: {
                        FicheblockCodemirror.escapeHtml(this.buf, carac);
                    }
                }
            }
            this.endSpan();
        }

        private void appendOperator(char c) throws IOException {
            this.buf.append("<span class=\"cm-operator\">");
            FicheblockCodemirror.escapeHtml(this.buf, c);
            this.buf.append("</span>");
        }

        private void appendFirstChar(char c) throws IOException {
            this.buf.append("<span class=\"cm-ficheblock-firstchars\">");
            FicheblockCodemirror.escapeHtml(this.buf, c);
            this.buf.append("</span>");
        }

        private void startSourceSpan() throws IOException {
            this.buf.append("<span class=\"cm-ficheblock-source\">");
        }

        private void startInitialeSpan() throws IOException {
            this.buf.append("<span class=\"cm-ficheblock-initial\">");
        }

        private void startOperatorSpan() throws IOException {
            this.buf.append("<span class=\"cm-operator\">");
        }

        private void startAttNameSpan() throws IOException {
            this.buf.append("<span class=\"cm-ficheblock-attname\">");
        }

        private void startStringSpan() throws IOException {
            this.buf.append("<span class=\"cm-string\">");
        }

        private void startFirstChars() throws IOException {
            this.buf.append("<span class=\"cm-ficheblock-firstchars\">");
        }

        private void startSpan(String classes) throws IOException {
            this.buf.append("<span class=\"");
            FicheblockCodemirror.escapeHtml(this.buf, classes);
            this.buf.append("\">");
        }

        private void startSpanWithSupplementary(String classes) throws IOException {
            this.buf.append("<span class=\"");
            FicheblockCodemirror.escapeHtml(this.buf, classes);
            this.buf.append(this.supplementaryClasses);
            this.buf.append("\">");
        }

        private void endSpan() throws IOException {
            this.buf.append("</span>");
        }

        private boolean withSupplementary() {
            return !this.supplementaryClasses.isEmpty();
        }
    }
}

