/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.utils.FicheUtils;

public final class ParaItem
extends AbstractList<Object>
implements FicheItem,
TextContent,
Serializable {
    private static final long serialVersionUID = 4L;
    private final Object[] partArray;

    private ParaItem(Object[] partArray) {
        this.partArray = partArray;
    }

    @Override
    public int size() {
        return this.partArray.length;
    }

    @Override
    public Object get(int i) {
        return this.partArray[i];
    }

    public String contentToString() {
        StringBuilder buf = new StringBuilder();
        for (Object obj : this.partArray) {
            if (obj instanceof String) {
                buf.append((String)obj);
                continue;
            }
            if (!(obj instanceof S)) continue;
            S s = (S)obj;
            buf.append(s.getValue());
        }
        return buf.toString();
    }

    public FicheBlocks toFicheBlocks() {
        P p = new P();
        for (Object obj : this.partArray) {
            if (obj instanceof String) {
                p.addText((String)obj);
                continue;
            }
            if (!(obj instanceof S)) continue;
            p.addS((S)obj);
        }
        return FicheUtils.toFicheBlocks(p);
    }

    public static class Builder
    implements TextContentBuilder {
        private final List<Object> partList = new ArrayList<Object>();

        @Override
        public void addText(String text) {
            Object obj;
            if (text.length() == 0) {
                return;
            }
            int size = this.partList.size();
            boolean merge = false;
            if (size > 0 && (obj = this.partList.get(size - 1)) instanceof String) {
                this.partList.set(size - 1, (String)obj + text);
                merge = true;
            }
            if (!merge) {
                this.partList.add(text);
            }
        }

        @Override
        public void addS(S s) {
            this.partList.add(s);
        }

        public ParaItem toParaItem() {
            return new ParaItem(this.partList.toArray());
        }
    }
}

