/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.roles;

import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.io.IOException;
import net.fichotheque.SubsetKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class RoleDefXMLPart
extends XMLPart {
    public RoleDefXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addRoleDef(RoleDef roleDef) throws IOException {
        this.addRoleDef(roleDef, null);
    }

    public void addRoleDef(RoleDef roleDef, @Nullable SubsetEligibility subsetEligibility) throws IOException {
        if (subsetEligibility == null) {
            subsetEligibility = EligibilityUtils.ALL_SUBSET_ELIGIBILITY;
        }
        this.openTag("role");
        LabelUtils.addLabels(this, roleDef.getTitleLabels());
        for (RoleDef.SubsetEntry entry : roleDef.getSubsetEntryList()) {
            SubsetKey subsetKey = entry.getSubsetKey();
            if (!subsetEligibility.accept(subsetKey)) continue;
            this.appendSubsetPermission(subsetKey, entry.getPermission());
        }
        AttributeUtils.addAttributes(this, roleDef.getAttributes());
        this.closeTag("role");
    }

    private void appendSubsetPermission(SubsetKey subsetKey, Permission permission) throws IOException {
        short level = permission.getLevel();
        this.startOpenTag("subset-permission");
        this.addAttribute("subset", subsetKey.getKeyString());
        this.addAttribute("level", RoleUtils.levelToString(level));
        if (level != 2) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            if (subsetKey.isCorpusSubset()) {
                FichePermission fichePermission = (FichePermission)permission.getCustomPermission();
                if (fichePermission.create()) {
                    this.addEmptyElement("create");
                }
                this.startOpenTag("read");
                this.addAttribute("type", RoleUtils.fichePermissionTypeToString(fichePermission.read()));
                this.closeEmptyTag();
                this.startOpenTag("write");
                this.addAttribute("type", RoleUtils.fichePermissionTypeToString(fichePermission.write()));
                this.closeEmptyTag();
            }
            this.closeTag("subset-permission");
        }
    }
}

