/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import net.fichotheque.namespaces.IconSpace;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.base64.Base64;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.ns.NameSpace;
import net.mapeadores.util.xml.svg.SvgWriter;

public class Icon32SvgWriter
extends SvgWriter {
    private static final String TEXT_ONLY_PATH = "M 0 10 h 32 V 32 H 0 Z";
    private static final String CARTOUCHE_ONLY_PATH = "M 0 0 h 32 v 10 A 21,21 0 0,0 10,32 H 0 Z";
    private static final String TEXT_AND_CARTOUCHE_PATH = "M 0 10 h 32 A 21,21 0 0,0 10,32 H 0 Z";
    private final BdfServer bdfServer;
    private final RelativePath cartouchePath;
    private final Attribute textIconAttribute;
    private final String iconClipPath;

    public Icon32SvgWriter(BdfServer bdfServer) {
        super(true);
        this.bdfServer = bdfServer;
        this.cartouchePath = Icon32SvgWriter.getCartouchePath(bdfServer);
        this.textIconAttribute = Icon32SvgWriter.getTextIconAttribute(bdfServer);
        this.iconClipPath = Icon32SvgWriter.getClipPath(this.cartouchePath, this.textIconAttribute);
    }

    public void open() throws IOException {
        this.addNameSpace(NameSpace.XLINK_NAMESPACE);
        this.openSvg(32, 32);
        this.appendDefs();
    }

    public void appendBitmapIcon() throws IOException {
        String base64;
        DocStream bitmapIcon = this.bdfServer.getResourceDocStream(StorageUtils.ICON32);
        try (InputStream is = bitmapIcon.getInputStream();){
            byte[] byteArray = IOUtils.toByteArray(is);
            base64 = Base64.encodeBase64String(byteArray);
        }
        this.startImageOpenTag("data:image/png;base64," + base64, 0, 0, 32, 32);
        if (this.iconClipPath != null) {
            this.addAttribute("style", "clip-path: url(#iconClip);");
        }
        this.closeEmptyTag();
    }

    public void appendBitmapCartouche() throws IOException {
        String base64;
        if (this.cartouchePath == null) {
            return;
        }
        DocStream cartoucheIcon = this.bdfServer.getResourceDocStream(this.cartouchePath);
        if (cartoucheIcon == null) {
            return;
        }
        try (InputStream is = cartoucheIcon.getInputStream();){
            byte[] byteArray = IOUtils.toByteArray(is);
            base64 = Base64.encodeBase64String(byteArray);
        }
        this.startImageOpenTag("data:image/png;base64," + base64, 16, 16, 16, 16);
        this.closeEmptyTag();
    }

    public void appendIconText() throws IOException {
        if (this.textIconAttribute == null) {
            return;
        }
        String text = this.textIconAttribute.getFirstValue().replace('_', '\u00a0');
        String style = "font-weight:bold;font-size:10px;font-family:monospace;fill:#000000;";
        int size = this.textIconAttribute.size();
        if (size > 1) {
            StringBuilder buf = new StringBuilder(style);
            for (int i = 1; i < size; ++i) {
                buf.append((String)this.textIconAttribute.get(i));
                buf.append(';');
            }
            style = buf.toString();
        }
        this.startTextOpenTag(1, 9);
        this.addStyleAttribute(style);
        this.endOpenTag();
        this.addText(text);
        this.closeText();
    }

    public void close() throws IOException {
        this.closeSvg();
    }

    private void appendDefs() throws IOException {
        if (this.iconClipPath != null) {
            this.openTag("defs");
            this.startOpenTag("clipPath");
            this.addAttribute("id", "iconClip");
            this.endOpenTag();
            this.startOpenTag("path");
            this.addAttribute("d", this.iconClipPath);
            this.closeEmptyTag();
            this.closeTag("clipPath");
            this.closeTag("defs");
        }
    }

    private void write() throws IOException {
        this.open();
        this.appendBitmapIcon();
        this.appendBitmapCartouche();
        this.appendIconText();
        this.close();
    }

    private static RelativePath getCartouchePath(BdfServer bdfServer) {
        Attribute cartoucheAttribute = bdfServer.getFichotheque().getFichothequeMetadata().getAttributes().getAttribute(IconSpace.CARTOUCHE_KEY);
        if (cartoucheAttribute != null) {
            try {
                return RelativePath.parse(cartoucheAttribute.getFirstValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Attribute getTextIconAttribute(BdfServer bdfServer) {
        return bdfServer.getFichotheque().getFichothequeMetadata().getAttributes().getAttribute(IconSpace.TEXT_KEY);
    }

    private static String getClipPath(RelativePath cartouchePath, Attribute textAttribute) {
        if (cartouchePath == null) {
            if (textAttribute == null) {
                return null;
            }
            return TEXT_ONLY_PATH;
        }
        if (textAttribute == null) {
            return CARTOUCHE_ONLY_PATH;
        }
        return TEXT_AND_CARTOUCHE_PATH;
    }

    public static String getSvgString(BdfServer bdfServer) {
        Icon32SvgWriter svgWriter = new Icon32SvgWriter(bdfServer);
        StringBuilder buf = new StringBuilder(1024);
        svgWriter.setAppendable(buf);
        svgWriter.setIndentLength(0);
        try {
            svgWriter.appendXMLDeclaration();
            svgWriter.write();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

