/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.corpus.FieldGenerationParser;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessageException;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.StringUtils;

class MetadataBlock
extends OverviewBlock {
    private final CorpusMetadata corpusMetadata;
    private final AttributeChangeBuilder attributeChangeBuilder = new AttributeChangeBuilder();
    private final Map<String, LabelChangeBuilder> phraseChangeMap = new HashMap<String, LabelChangeBuilder>();
    private final LabelChangeBuilder titleLabelChangeBuilder = new LabelChangeBuilder();
    private FieldKey geolocalisationFieldKey;
    private boolean removeGeolocalisation;
    private FieldGeneration fieldGeneration;
    private String[] order;

    MetadataBlock(int lineNumber, CorpusMetadata corpusMetadata) {
        super(lineNumber, "metadata");
        this.corpusMetadata = corpusMetadata;
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        LabelChangeBuilder labelChangeBuilder = this.getLabelChangeBuilder(name);
        if (labelChangeBuilder == null) {
            return false;
        }
        labelChangeBuilder.putLabel(lang, text);
        return true;
    }

    private LabelChangeBuilder getLabelChangeBuilder(String name) {
        if (name.equals("title")) {
            return this.titleLabelChangeBuilder;
        }
        if (name.startsWith("phrase_")) {
            String phraseName = name.substring("phrase_".length());
            LabelChangeBuilder labelChangeBuilder = this.phraseChangeMap.get(phraseName);
            if (labelChangeBuilder != null) {
                return labelChangeBuilder;
            }
            if (FichothequeUtils.isValidPhraseName(name)) {
                labelChangeBuilder = new LabelChangeBuilder();
                this.phraseChangeMap.put(phraseName, labelChangeBuilder);
                return labelChangeBuilder;
            }
            return null;
        }
        return null;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "order": {
                this.order = StringUtils.getTechnicalTokens(value, true);
                break;
            }
            case "geolocalisation": {
                if (value.isEmpty()) {
                    this.removeGeolocalisation = true;
                    break;
                }
                try {
                    FieldKey fieldKey = FieldKey.parse(value);
                    if (!fieldKey.isProp()) {
                        throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.wrong.parametervalue", key, value);
                    }
                    this.geolocalisationFieldKey = fieldKey;
                    break;
                }
                catch (ParseException pe) {
                    throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.wrong.parametervalue", key, value);
                }
            }
            case "fieldgeneration": {
                LineLogsBuilder lingeLogsBuilder = new LineLogsBuilder();
                this.fieldGeneration = FieldGenerationParser.parse(value, lingeLogsBuilder);
                if (!lingeLogsBuilder.hasMessage()) break;
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.wrong.parametervalue", key, value);
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.attributeChangeBuilder;
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        CorpusMetadataEditor corpusMetadataEditor = editSession.getFichothequeEditor().getCorpusEditor(this.corpusMetadata.getCorpus()).getCorpusMetadataEditor();
        corpusMetadataEditor.changeLabels(null, this.titleLabelChangeBuilder.toLabelChange());
        for (Map.Entry<String, LabelChangeBuilder> entry : this.phraseChangeMap.entrySet()) {
            corpusMetadataEditor.changeLabels(entry.getKey(), entry.getValue().toLabelChange());
        }
        corpusMetadataEditor.changeAttributes(this.attributeChangeBuilder.toAttributeChange());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
        CorpusMetadataEditor corpusMetadataEditor = editSession.getFichothequeEditor().getCorpusEditor(this.corpusMetadata.getCorpus()).getCorpusMetadataEditor();
        if (this.geolocalisationFieldKey != null) {
            CorpusField corpusField = this.corpusMetadata.getCorpusField(this.geolocalisationFieldKey);
            if (corpusField != null) {
                try {
                    corpusMetadataEditor.setGeolocalisationField(corpusField);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (this.removeGeolocalisation) {
            corpusMetadataEditor.setGeolocalisationField(null);
        }
        if (this.fieldGeneration != null) {
            corpusMetadataEditor.setFieldGeneration(this.fieldGeneration);
        }
        if (this.order != null) {
            editSession.getBdfServerEditor().setPositionArray(uiComponents, this.order);
        }
    }
}

