/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionConstants;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.utils.FieldOptionUtils;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;
import net.mapeadores.util.text.LabelChangeBuilder;

class FieldBlock
extends OverviewBlock {
    private final CorpusMetadata corpusMetadata;
    private final FieldKey fieldKey;
    private final FieldUiBuilder builder;
    private final LabelChangeBuilder labelChangeBuilder = new LabelChangeBuilder();
    private final String ficheItemType;
    private final Map<String, Object> optionMap = new HashMap<String, Object>();
    private CorpusField corpusField;

    FieldBlock(int lineNumber, FieldUi fieldUi, CorpusMetadata corpusMetadata) {
        super(lineNumber, fieldUi);
        this.builder = FieldUiBuilder.derive(fieldUi);
        this.fieldKey = fieldUi.getFieldKey();
        this.corpusMetadata = corpusMetadata;
        this.ficheItemType = corpusMetadata.getCorpusField(this.fieldKey).getFicheItemType();
    }

    FieldBlock(int lineNumber, FieldKey fieldKey, String ficheItemType, CorpusMetadata corpusMetadata) {
        super(lineNumber, fieldKey.getKeyString());
        this.builder = new FieldUiBuilder(fieldKey);
        this.fieldKey = fieldKey;
        this.corpusMetadata = corpusMetadata;
        this.ficheItemType = ficheItemType;
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        if (!this.isValidText(name)) {
            return false;
        }
        this.labelChangeBuilder.putLabel(lang, text);
        return true;
    }

    private boolean isValidText(String labelName) {
        switch (labelName) {
            case "label": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "status": {
                if (!FieldUi.isModifiableStatus(this.fieldKey)) {
                    throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
                }
                String status = this.checkStatus(lineNumber, value);
                this.builder.setStatus(status);
                break;
            }
            case "type": {
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        switch (key) {
            case "field": {
                try {
                    name = FieldOptionConstants.checkAlias(name);
                    FieldOptionUtils.checkUsage(name, this.fieldKey, this.ficheItemType);
                }
                catch (FieldOptionException foe) {
                    throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.keyparam", name);
                }
                try {
                    Object optionObject = FieldOptionUtils.parseOptionValue(name, value);
                    this.optionMap.put(name, optionObject);
                    break;
                }
                catch (FieldOptionException foe) {
                    throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.wrong.parametervalue", name, value);
                }
            }
            case "ui": {
                Object uiOptionObject = this.parseOptionValue(name, value);
                if (uiOptionObject == null) break;
                this.builder.putOption(name, uiOptionObject);
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.builder.getAttributeChangeBuilder();
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        CorpusMetadataEditor corpusMetadataEditor = editSession.getFichothequeEditor().getCorpusEditor(this.corpusMetadata.getCorpus()).getCorpusMetadataEditor();
        this.corpusField = this.corpusMetadata.getCorpusField(this.fieldKey);
        if (this.corpusField == null) {
            try {
                this.corpusField = corpusMetadataEditor.createCorpusField(this.fieldKey, this.ficheItemType);
            }
            catch (ExistingFieldKeyException iee) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        corpusMetadataEditor.changeFieldLabels(this.corpusField, this.labelChangeBuilder.toLabelChange());
        editSession.getBdfServerEditor().putComponentUi(uiComponents, this.builder.toFieldUi());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
        CorpusMetadataEditor corpusMetadataEditor = editSession.getFichothequeEditor().getCorpusEditor(this.corpusMetadata.getCorpus()).getCorpusMetadataEditor();
        for (Map.Entry<String, Object> entry : this.optionMap.entrySet()) {
            try {
                corpusMetadataEditor.setFieldOption(this.corpusField, entry.getKey(), entry.getValue());
            }
            catch (FieldOptionException fieldOptionException) {}
        }
    }
}

