/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.AddendaEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AlbumEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.LiageEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.FieldEntryFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.thesaurus.ThesaurusEntryFactory;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;

public final class FormEntryProviderFactory {
    private FormEntryProviderFactory() {
    }

    public static FormEntryProvider newInstance(OutputParameters outputParameters) {
        return FormEntryProviderFactory.newInstance(FicheFormUtils.toFicheFormParameters(outputParameters));
    }

    public static FormEntryProvider newInstance(FicheFormParameters ficheFormParameters) {
        return new InternalFormEntryProvider(ficheFormParameters);
    }

    private static class InternalFormEntryProvider
    implements FormEntryProvider {
        private final FicheFormParameters ficheFormParameters;

        public InternalFormEntryProvider(FicheFormParameters ficheFormParameters) {
            this.ficheFormParameters = ficheFormParameters;
        }

        @Override
        public FormEntry.Include getFormEntry(FichePointeur fichePointeur, IncludeUi includeUi) {
            if (includeUi instanceof SpecialIncludeUi) {
                SpecialIncludeUi specialIncludeUi = (SpecialIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, specialIncludeUi)) {
                    return null;
                }
                switch (specialIncludeUi.getName()) {
                    case "liage": {
                        LiageEntryBuilder builder = LiageEntryBuilder.check(fichePointeur, this.ficheFormParameters, specialIncludeUi);
                        if (builder != null) {
                            return builder.toLiageEntry();
                        }
                        return null;
                    }
                }
                return null;
            }
            if (includeUi instanceof SubsetIncludeUi) {
                SubsetIncludeUi subsetIncludeUi = (SubsetIncludeUi)includeUi;
                if (!FicheFormUtils.hasAccess(this.ficheFormParameters, subsetIncludeUi)) {
                    return null;
                }
                switch (subsetIncludeUi.getCategory()) {
                    case 4: {
                        AddendaEntryBuilder builder = AddendaEntryBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (builder != null) {
                            return builder.toAddendaEntry();
                        }
                        return null;
                    }
                    case 5: {
                        AlbumEntryBuilder builder = AlbumEntryBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (builder != null) {
                            return builder.toAlbumEntry();
                        }
                        return null;
                    }
                    case 1: {
                        CorpusEntryBuilder builder = CorpusEntryBuilder.check(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                        if (builder != null) {
                            return builder.toCorpusEntry();
                        }
                        return null;
                    }
                    case 2: {
                        return ThesaurusEntryFactory.newInstance(fichePointeur, this.ficheFormParameters, subsetIncludeUi);
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public FormEntry.Field getFormEntry(FichePointeur fichePointeur, FieldUi fieldUi) {
            CorpusField corpusField = FicheFormUtils.getCorpusField(fichePointeur, fieldUi);
            if (corpusField == null) {
                return null;
            }
            if (corpusField.isGenerated()) {
                return null;
            }
            if (!FicheFormUtils.hasAccess(this.ficheFormParameters, fieldUi)) {
                return null;
            }
            return FieldEntryFactory.newInstance(fichePointeur, this.ficheFormParameters, corpusField, fieldUi);
        }
    }
}

