/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.impl;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.api.central.CentralUserEditor;
import fr.exemole.bdfserver.multi.impl.MultiStorageFileCatalog;
import fr.exemole.bdfserver.multi.xml.CentralUserXMLPart;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import net.fichotheque.EditOrigin;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.sphere.LoginKey;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

class CentralUserImpl
implements CentralUser {
    private final LoginKey loginKey;
    private String encryptedPassword = "";
    private UserLangContext userLangContext = LocalisationUtils.DEFAULT_LANGCONTEXT;
    private Locale customFormatLocale;
    private LangPreference customLangPreference;
    private PersonCore person = PersonCoreUtils.EMPTY_PERSONCORE;
    private InternalEmail email = null;
    private String status = "active";
    private AttributesCache attributesCache = null;

    CentralUserImpl(LoginKey loginKey) {
        this.loginKey = loginKey;
    }

    @Override
    public LoginKey getLoginKey() {
        return this.loginKey;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public UserLangContext getUserLangContext() {
        return this.userLangContext;
    }

    @Override
    public PersonCore getPerson() {
        return this.person;
    }

    @Override
    public EmailCore getEmail() {
        return this.email;
    }

    @Override
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributesCache == null) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        return this.attributesCache.getAttributes();
    }

    @Override
    public Locale getCustomFormatLocale() {
        return this.customFormatLocale;
    }

    @Override
    public LangPreference getCustomLangPreference() {
        return this.customLangPreference;
    }

    private synchronized boolean innerRemoveAttribute(AttributeKey attributeKey) {
        if (this.attributesCache == null) {
            return false;
        }
        return this.attributesCache.removeAttribute(attributeKey);
    }

    private synchronized boolean innerPutAttribute(Attribute attribute) {
        if (this.attributesCache == null) {
            this.attributesCache = new AttributesCache();
        }
        return this.attributesCache.putAttribute(attribute);
    }

    private boolean setEmail(EmailCore newEmail) {
        if (newEmail == null) {
            if (this.email != null) {
                this.email = null;
                return true;
            }
            return false;
        }
        String realName = newEmail.getRealName();
        if (realName.equals(this.person.toStandardStyle())) {
            realName = "";
        }
        InternalEmail newInternalEmail = new InternalEmail(newEmail.getAddrSpec(), realName);
        if (this.email == null) {
            this.email = newInternalEmail;
            return true;
        }
        if (this.email.equals(newInternalEmail)) {
            return false;
        }
        this.email = newInternalEmail;
        return true;
    }

    CentralUserEditorImpl getCentalUserEditor(EditOrigin editOrigin) {
        return new CentralUserEditorImpl(this, editOrigin);
    }

    private class InternalEmail
    implements EmailCore {
        private final String addrSpec;
        private final String realName;

        private InternalEmail(String addrSpec, String realName) {
            this.addrSpec = addrSpec;
            this.realName = realName;
        }

        @Override
        public String getAddrSpec() {
            return this.addrSpec;
        }

        @Override
        public String getRealName() {
            return this.realName;
        }

        @Override
        public String getComputedRealName() {
            if (this.realName.isEmpty()) {
                return CentralUserImpl.this.person.toStandardStyle();
            }
            return this.realName;
        }

        public int hashCode() {
            return this.addrSpec.hashCode() + this.realName.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            InternalEmail otherEmail = (InternalEmail)other;
            return otherEmail.addrSpec.equals(this.addrSpec) && otherEmail.realName.equals(this.realName);
        }
    }

    static class CentralUserEditorImpl
    implements CentralUserEditor {
        private final CentralUserImpl centralUserImpl;
        private final EditOrigin editOrigin;
        private boolean withChanges = false;

        private CentralUserEditorImpl(CentralUserImpl centralUserImpl, EditOrigin editOrigin) {
            this.centralUserImpl = centralUserImpl;
            this.editOrigin = editOrigin;
        }

        @Override
        public boolean setStatus(String status) {
            String currentStatus = this.centralUserImpl.getStatus();
            if (!status.equals(currentStatus)) {
                this.centralUserImpl.status = FichothequeConstants.checkRedacteurStatus(status);
                this.fireChange();
                return true;
            }
            return false;
        }

        @Override
        public boolean setPerson(PersonCore person) {
            PersonCore currentPerson = this.centralUserImpl.person;
            if (!PersonCoreUtils.areEqual(person, currentPerson)) {
                this.centralUserImpl.person = PersonCoreUtils.clonePersonCore(person);
                this.fireChange();
                return true;
            }
            return false;
        }

        @Override
        public boolean setEmail(EmailCore newEmail) {
            boolean done = this.centralUserImpl.setEmail(newEmail);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean setLangContext(Lang workingLang, Locale customFormatLocale, LangPreference customLangPreference) {
            this.centralUserImpl.userLangContext = LocalisationUtils.toUserLangContext(workingLang, customFormatLocale, customLangPreference);
            this.centralUserImpl.customFormatLocale = customFormatLocale;
            this.centralUserImpl.customLangPreference = customLangPreference;
            this.fireChange();
            return true;
        }

        @Override
        public boolean setEncryptedPassword(String encryptedPassword) {
            if (encryptedPassword == null) {
                encryptedPassword = "";
            }
            if (!encryptedPassword.equals(this.centralUserImpl.encryptedPassword)) {
                this.centralUserImpl.encryptedPassword = encryptedPassword;
                this.fireChange();
                return true;
            }
            return false;
        }

        @Override
        public boolean putAttribute(Attribute attribute) {
            boolean done = this.centralUserImpl.innerPutAttribute(attribute);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean removeAttribute(AttributeKey attributeKey) {
            boolean done = this.centralUserImpl.innerRemoveAttribute(attributeKey);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        boolean isWithChanges() {
            return this.withChanges;
        }

        void fireChange() {
            this.withChanges = true;
        }

        boolean saveChanges(StorageDirectory storageDirectory) {
            if (this.isWithChanges()) {
                StorageFile storageFile = MultiStorageFileCatalog.centralUser(storageDirectory, this.centralUserImpl.getLoginKey());
                try (BufferedWriter buf = storageFile.archiveAndGetWriter(this.editOrigin);){
                    AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
                    xmlWriter.appendXMLDeclaration();
                    CentralUserXMLPart part = new CentralUserXMLPart(xmlWriter);
                    part.appendCentralUser(this.centralUserImpl);
                }
                catch (IOException ioe) {
                    throw new BdfStorageException(ioe);
                }
                return true;
            }
            return false;
        }
    }
}

