/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.main;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.json.CellJson;
import net.fichotheque.json.MetadataJson;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.money.Amount;

public class TableJsonProperty
implements JsonProperty {
    private final BdfParameters bdfParameters;
    private final BdfUser bdfUser;
    private final SubsetTable subsetTable;
    private final TableExportContext tableExportContext;
    private final CellConverter cellConverter;
    private final String propertiesMapping;
    private final boolean withLabels;

    public TableJsonProperty(BdfParameters bdfParameters, SubsetTable subsetTable, TableExportContext tableExportContext, CellConverter cellConverter, String propertiesMapping, boolean withLabels) {
        this.bdfParameters = bdfParameters;
        this.bdfUser = bdfParameters.getBdfUser();
        this.subsetTable = subsetTable;
        this.tableExportContext = tableExportContext;
        this.cellConverter = cellConverter;
        this.propertiesMapping = propertiesMapping;
        this.withLabels = withLabels;
    }

    @Override
    public String getName() {
        return "table";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        SumResult sumResult;
        Subset subset = this.subsetTable.getSubset();
        Collection<SubsetItem> subsetItems = this.getSubsetItems(subset);
        Lang workingLang = this.bdfUser.getWorkingLang();
        List<ColDef> colDefList = this.subsetTable.getColDefList();
        int colCount = colDefList.size();
        boolean[] hiddenArray = new boolean[colCount];
        jw.object();
        jw.key("meta");
        jw.object();
        jw.key("lang").value(this.bdfUser.getWorkingLang().toString());
        jw.key("locale").value(this.bdfUser.getISOFormatLocaleString());
        jw.key("mapping").value(this.propertiesMapping);
        MetadataJson.subsetProperty(jw, this.subsetTable.getSubsetKey());
        jw.key("columns");
        jw.array();
        for (int j = 0; j < colCount; ++j) {
            ColDef colDef = colDefList.get(j);
            if (colDef.isFormula()) {
                hiddenArray[j] = true;
                continue;
            }
            hiddenArray[j] = false;
            String castType = colDef.getCastType();
            if (castType.isEmpty()) {
                castType = "string";
            }
            String dateStyle = null;
            if (castType.equals("date")) {
                dateStyle = (String)colDef.getParameterValue("datestyle");
            }
            jw.object();
            jw.key("name").value(colDef.getColName());
            jw.key("title").value(TableDefUtils.getColTitle(colDef, workingLang, this.tableExportContext.getSourceLabelProvider(), subset));
            jw.key("cast").value(castType);
            jw.key("match").value(colDef.getMatchingComponentName());
            if (dateStyle != null) {
                jw.key("datestyle").value(dateStyle);
            }
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
        jw.key("data");
        jw.array();
        this.writeSubsetItems(jw, subsetItems, hiddenArray, this.bdfUser);
        jw.endArray();
        if (this.cellConverter instanceof SumCellConverter && (sumResult = ((SumCellConverter)this.cellConverter).getSumResult(this.subsetTable)).hasColumnSum()) {
            List<SumResult.Entry> entryList = sumResult.getEntryList();
            jw.key("sum");
            jw.array();
            for (int j = 0; j < colCount; ++j) {
                if (hiddenArray[j]) continue;
                SumResult.ColumnSum columnSum = entryList.get(j).getColumnSum();
                if (columnSum != null) {
                    this.writeColumnSum(jw, columnSum, this.bdfUser);
                    continue;
                }
                jw.value(false);
            }
            jw.endArray();
        }
        jw.endObject();
    }

    private void writeSubsetItems(JSONWriter jw, Collection<SubsetItem> subsetItems, boolean[] hiddenArray, LangContext langContext) throws IOException {
        if (!this.withLabels) {
            langContext = null;
        }
        Predicate<SubsetItem> editablePredicate = this.getEditablePredicate();
        for (SubsetItem subsetItem : subsetItems) {
            Cell[] cellArray = this.cellConverter.toCellArray(subsetItem);
            if (cellArray == null) continue;
            jw.object();
            jw.key("id").value(subsetItem.getId());
            jw.key("editable").value(editablePredicate.test(subsetItem));
            CellJson.cellArrayMappingProperty(jw, cellArray);
            jw.endObject();
        }
    }

    private void writeColumnSum(JSONWriter jw, SumResult.ColumnSum columnSum, LangContext langContext) throws IOException {
        if (columnSum instanceof SumResult.IntegerColumnSum) {
            CellJson.value(jw, "integer", ((SumResult.IntegerColumnSum)columnSum).getResult(), langContext);
        } else if (columnSum instanceof SumResult.DecimalColumnSum) {
            CellJson.value(jw, "decimal", ((SumResult.DecimalColumnSum)columnSum).getResult(), langContext);
        } else if (columnSum instanceof SumResult.PercentageColumnSum) {
            CellJson.value(jw, "percentage", ((SumResult.PercentageColumnSum)columnSum).getResult(), langContext);
        } else if (columnSum instanceof SumResult.MoneyColumnSum) {
            jw.object();
            SumResult.MoneyColumnSum moneyColumnSum = (SumResult.MoneyColumnSum)columnSum;
            int resultCount = moneyColumnSum.getResultCount();
            jw.key("moneyArray");
            jw.array();
            for (int k = 0; k < resultCount; ++k) {
                Amount resultAmount = moneyColumnSum.getResult(k);
                CellJson.value(jw, "money", resultAmount, langContext);
            }
            jw.endArray();
            jw.endObject();
        } else {
            jw.value(false);
        }
    }

    private Collection<SubsetItem> getSubsetItems(Subset subset) {
        if (subset instanceof Corpus) {
            Fiches fiches = this.bdfUser.getSelectedFiches();
            return CorpusUtils.getFicheMetaListByCorpus(fiches, subset.getSubsetKey());
        }
        if (subset instanceof Thesaurus) {
            Thesaurus thesaurus = (Thesaurus)subset;
            if (thesaurus == null || thesaurus.size() == 0) {
                return FichothequeUtils.EMPTY_SUBSETITEMLIST;
            }
            return ThesaurusUtils.toSubsetItemList(thesaurus, -1);
        }
        throw new SwitchException("Unknown subset: " + subset.getSubsetKeyString());
    }

    private Predicate<SubsetItem> getEditablePredicate() {
        SubsetKey subsetKey = this.subsetTable.getSubsetKey();
        PermissionSummary permissionSummary = this.bdfParameters.getPermissionSummary();
        boolean isAdmin = permissionSummary.isSubsetAdmin(subsetKey);
        if (isAdmin) {
            return EligibilityUtils.ALL_SUBSETITEM_PREDICATE;
        }
        if (subsetKey.isCorpusSubset()) {
            return new EditablePredicate(permissionSummary);
        }
        return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
    }

    private static class EditablePredicate
    implements Predicate<SubsetItem> {
        private final PermissionSummary permissionSummary;

        private EditablePredicate(PermissionSummary permissionSummary) {
            this.permissionSummary = permissionSummary;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.permissionSummary.canWrite((FicheMeta)subsetItem);
        }
    }
}

