/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.interaction.domains.SphereDomain;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereCommandBoxUtils;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.html.CommandBox;

public class RedacteurUserFormHtmlProducer
extends BdfServerHtmlProducer
implements SphereDomain {
    private final Redacteur redacteur;

    public RedacteurUserFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.redacteur = this.bdfUser.getRedacteur();
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("sphere").family("USR").veil(true).page("redacteur-userform");
        UserAllow userAllow = this.bdfServer.getPolicyManager().getUserAllow();
        boolean sphereSupervisorAllowed = PermissionCheck.isAllowedBySphereSupervisor(this.bdfServer, this.bdfUser, this.redacteur.getSubsetName());
        if (userAllow.isDataChangeAllowed() && sphereSupervisorAllowed) {
            SphereCommandBoxUtils.printRedacteurChangeBox(this, commandBox, this.redacteur, this.bdfServer);
        }
        SphereCommandBoxUtils.printLangBox(this, commandBox, this.redacteur, this.bdfUser, this.bdfServer, this.formatLocale);
        if (userAllow.isPasswordChangeAllowed() && sphereSupervisorAllowed) {
            SphereCommandBoxUtils.printRedacteurPasswordBox(this, commandBox, this.redacteur);
        }
        SphereCommandBoxUtils.printTemplatesBox(this, commandBox, this.bdfServer, this.bdfUser.getWorkingLang(), this.redacteur, this.bdfUser);
        SphereCommandBoxUtils.printDefaultTableExportParametersBox(this, commandBox, this.redacteur, this.bdfUser);
        SphereCommandBoxUtils.printCustomizeUIBox(this, commandBox, this.redacteur, this.bdfUser);
        this.end();
    }
}

