/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.selection;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.forms.SelectionFormPrinter;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.List;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.SelectionDef;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;

public class SelectFormHtmlProducer
extends BdfServerHtmlProducer {
    public static final String BEFORE_INSERT = "before";
    public static final String AFTER_INSERT = "after";
    private static final SelectOption[] SORTTYPE_OPTIONS = new SelectOption[]{SelectOption.init("title-asc").textL10nObject("_ label.selection.sorttype_title"), SelectOption.init("id-asc").textL10nObject("_ label.selection.sorttype_id"), SelectOption.init("creationdate-desc").textL10nObject("_ label.selection.sorttype_creationdate"), SelectOption.init("modificationdate-desc").textL10nObject("_ label.selection.sorttype_modificationdate")};
    private final PermissionSummary permissionSummary;
    private final String sortType;
    private FicheQuery ficheQuery;

    public SelectFormHtmlProducer(BdfParameters bdfParameters, String selectionName) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.addJsLib(MiscJsLibs.SELECTFORM);
        this.addThemeCss("selectform.css");
        this.initFicheQuery(selectionName);
        this.initHook(SelectFormHtmlProducer.class);
        this.sortType = BdfUserUtils.getCurrentSortType(this.bdfServer, this.bdfUser);
    }

    private void initFicheQuery(String selectionName) {
        if (selectionName != null && selectionName.equals("_default")) {
            this.ficheQuery = this.bdfUser.getPrefs().getDefaultFicheQuery();
        }
        if (this.ficheQuery == null) {
            this.ficheQuery = this.bdfUser.getFicheQuery();
        }
    }

    @Override
    public void printHtml() {
        this.start();
        this.SCRIPT().__jsObject("SelectForm.ARGS", this.initSelectFormArgs())._SCRIPT();
        this.printToolBarLinks();
        this.insertInclude(BEFORE_INSERT);
        this.printStandardUnit();
        this.printSelectionDefUnit();
        this.insertInclude(AFTER_INSERT);
        this.end();
    }

    public FicheQuery getFicheQuery() {
        return this.ficheQuery;
    }

    protected void printToolBarLinks() {
        this.DIV("global-PageToolbar").__(this.printPageLink("action-defaultselection-Save", "_ link.selection.default_save", "cmd", "UserDefaultSelection")).__space().__(this.printPageLink("action-defaultselection-Load", "_ link.selection.default_load", "selectionname", "_default"))._DIV();
    }

    private void printStandardUnit() {
        this.__(PageUnit.start("action-Selection", "_ title.selection.fichesselection").sectionCss("unit-Unit selectform-Unit")).FORM_get("selection", "List").INPUT_hidden(ParameterMap.init().command("UserSelectionChange").page("main", "fiches")).P("selectform-Submit").__(this.printHtmlSelectSortType()).__space().__(Button.submit("action-Selection", "_ submit.selection.selectionchange"))._P().__(SelectionFormPrinter.init(this.getFicheQuery(), this.bdfServer, this.bdfUser, this.permissionSummary, this).printFieldsets())._FORM().__(PageUnit.END);
    }

    private boolean printSelectionDefUnit() {
        List<SelectionDef> selectionDefList = this.bdfServer.getSelectionManager().getSelectionDefList();
        if (selectionDefList.isEmpty()) {
            return false;
        }
        List<SelectOption> optionList = BdfHtmlUtils.toAvailableOptionList(selectionDefList, this.workingLang);
        if (optionList.isEmpty()) {
            return false;
        }
        String current = "";
        Object currentValue = this.bdfUser.getParameterValue("bdf.selection.defname");
        if (currentValue != null && currentValue instanceof String) {
            current = (String)currentValue;
        }
        this.__(PageUnit.start("action-Selection", "_ title.selection.byselectiondef")).FORM_get("selection", "List").INPUT_hidden(ParameterMap.init().command("UserSelectionChange").page("main", "fiches").param("selectiontype", "selectiondef")).__(Grid.START).__(Grid.selectRow((Object)"_ label.global.selectiondef", this.name("selection"), SelectOption.consumer(optionList, (Object)current))).__(Grid.selectRow((Object)"_ label.selection.sorttype", this.name("sorttype"), SelectOption.consumer(SORTTYPE_OPTIONS, (Object)this.sortType))).__(Grid.END).__(Button.COMMAND, Button.submit("action-Selection", "_ submit.selection.selectionchange"))._FORM().__(PageUnit.END);
        return true;
    }

    private boolean printPageLink(String actionClass, String titleLocKey, String extraParamName, String extraParamValue) {
        this.A(HA.href(BH.domain("selection").page("selectform").param(extraParamName, extraParamValue)).classes("global-button-Transparent global-button-Transparent32").addClass(actionClass).titleLocKey(titleLocKey)).__(Button.ICON)._A();
        return true;
    }

    protected boolean printHtmlSelectSortType() {
        this.SPAN().__localize("_ label.selection.sorttype").__colon()._SPAN().SELECT("sorttype").__(SelectOption.consumer(SORTTYPE_OPTIONS, (Object)this.sortType))._SELECT();
        return true;
    }

    private JsObject initSelectFormArgs() {
        String dateInputsType = this.bdfUser.getPrefs().getDateInputsType();
        return JsObject.init().put("dateInputs", dateInputsType);
    }
}

