/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.BlankHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.DiagramsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.FichesGeoHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.GlobalStatsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.HistoryHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.IsoHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.MementoHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.misc.TableExportFormHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.Subset;
import net.mapeadores.util.logging.ErrorMessageException;

public final class MiscHtmlProducerFactory {
    private MiscHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "blank": {
                return new BlankHtmlProducer(parameters, MiscHtmlProducerFactory.getBodyCssClass(requestHandler));
            }
            case "diagrams": {
                parameters.checkFichothequeAdmin();
                return new DiagramsHtmlProducer(parameters);
            }
            case "globalstats": {
                parameters.checkFichothequeAdmin();
                return new GlobalStatsHtmlProducer(parameters);
            }
            case "history": {
                Subset subset = requestHandler.hasParameter("corpus") ? requestHandler.getMandatoryCorpus() : requestHandler.getMandatorySubset();
                int id = requestHandler.getMandatoryId();
                PermissionChecker.init(parameters).checkHistory(subset, id);
                return new HistoryHtmlProducer(parameters, subset, id);
            }
            case "iso-countries": 
            case "iso-languages": {
                return new IsoHtmlProducer(parameters, page);
            }
            case "fichesgeo": {
                return new FichesGeoHtmlProducer(parameters);
            }
            case "memento": {
                return new MementoHtmlProducer(parameters);
            }
            case "tableexportform": {
                return new TableExportFormHtmlProducer(parameters);
            }
        }
        return null;
    }

    private static String getBodyCssClass(RequestHandler requestHandler) throws ErrorMessageException {
        String backgroundType;
        switch (backgroundType = requestHandler.getTrimedParameter("background")) {
            case "listframe": {
                return "global-body-ListFrame";
            }
            case "toolwindow": {
                return "global-body-ToolWindow";
            }
            case "transparent": {
                return "global-body-Transparent";
            }
            case "topborder": {
                return "global-body-TopBorder";
            }
            case "white": {
                return "global-body-White";
            }
        }
        return "global-body-Default";
    }
}

