/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import fr.exemole.bdfserver.tools.BdfHrefProvider;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class MainHtmlUtils {
    public static final HtmlWrapper DISPLAYTABLE_TREE = Tree.tree("displaytable-Tree");
    public static final HtmlWrapper DISPLAYTABLE_LEAF = Tree.leaf("displaytable-Leaf");
    public static final BdfHrefProvider DEFAULT_BDFHREFPROVIDER = new DefaultBdfHrefProvider();

    private MainHtmlUtils() {
    }

    public static BdfHrefProvider getMainProvider(RequestMap requestMap) {
        String fiche = requestMap.getParameter("fiche");
        if (fiche != null) {
            return new FicheBdfHrefProvider(fiche);
        }
        return DEFAULT_BDFHREFPROVIDER;
    }

    public static Fiches getFiches(RequestHandler requestHandler) throws ErrorMessageException {
        if (requestHandler.hasParameter("corpus")) {
            FicheMeta ficheMeta = requestHandler.getMandatoryFicheMeta();
            return CorpusUtils.toSingletonFiches(ficheMeta);
        }
        return requestHandler.getBdfUser().getSelectedFiches();
    }

    public static String getMainPageName(BdfServerHtmlProducer bhp) {
        if (bhp.isWithJavascript()) {
            return BdfInstructionUtils.getAbsolutePageName("main", "iframes");
        }
        return BdfInstructionUtils.getAbsolutePageName("main", "frameset");
    }

    public static boolean printDisplayTableDetails(BdfServerHtmlProducer hp, BdfServer bdfServer, BdfUser bdfUser, Subset subset, boolean withFicheMailing, HtmlAttributes detailsAttributes) {
        SubsetKey subsetKey = subset.getSubsetKey();
        List<TableExportDescription> list = BdfTableExportUtils.getAvailableTableExportDescriptionList(bdfServer.getTableExportManager(), subset.getSubsetKey(), "table");
        String currentTableExportName = bdfUser.getPrefs().getAttributes().getFirstValue(BdfUserSpace.toTableAttributeKey(subset));
        TableExportDescription currentTableExportDescription = null;
        if (currentTableExportName != null) {
            for (TableExportDescription tableExportDescription : list) {
                String name = tableExportDescription.getName();
                if (!name.equals(currentTableExportName)) continue;
                currentTableExportDescription = tableExportDescription;
                break;
            }
            if (currentTableExportDescription == null) {
                currentTableExportName = null;
            }
        }
        String titleKey = "_ link.main.displaytable";
        if (subset instanceof Corpus) {
            titleKey = "_ link.main.displaytable_fiches";
        } else if (subset instanceof Thesaurus) {
            titleKey = "_ link.main.displaytable_motcles";
        }
        Lang workingLang = bdfUser.getWorkingLang();
        hp.DETAILS(detailsAttributes).SUMMARY().__localize(titleKey)._SUMMARY().__(DISPLAYTABLE_TREE, () -> {
            for (TableExportDescription tableExportDescription : list) {
                String name = tableExportDescription.getName();
                hp.__(DISPLAYTABLE_LEAF, () -> hp.SPAN("displaytable-Title").__escape(tableExportDescription.getTitle(workingLang)).__colon()._SPAN().__(MainHtmlUtils.printSupplementaryLinks(hp, subsetKey, name, withFicheMailing)));
            }
            hp.__(DISPLAYTABLE_LEAF, () -> hp.SPAN("displaytable-Title displaytable-Default").__localize("_ link.main.defaulttableformat").__colon()._SPAN().__(MainHtmlUtils.printSupplementaryLinks(hp, subsetKey, null, withFicheMailing)));
        })._DETAILS();
        return true;
    }

    private static boolean printSupplementaryLinks(HtmlPrinter hp, SubsetKey subsetKey, String tableExportName, boolean withMailing) {
        BdfHref displayHref = BH.domain("main").page("tablesheet").param("subset", subsetKey.getKeyString()).param("remember_action", "1");
        String subsetKeyString = subsetKey.getKeyString();
        String urlPrefix = "tables/" + subsetKeyString;
        if (tableExportName != null) {
            urlPrefix = urlPrefix + "-" + tableExportName;
            displayHref.param("tableexport", tableExportName);
        }
        Button button = Button.link().style("transparent");
        hp.__(button.href(displayHref).action("action-TableSheet").tooltipMessage("_ link.global.version", "HTML").target("Edition")).__(button.href(urlPrefix + ".csv").action("action-Csv").tooltipMessage("_ link.global.version", "CSV").target(null)).__(button.href(urlPrefix + ".ods").action("action-Ods").tooltipMessage("_ link.global.version", "ODS").target(null));
        if (withMailing) {
            BdfHref sendHref = BH.domain("mailing").page("send-form").subset(subsetKey).param("type", "tableexport");
            if (tableExportName != null) {
                sendHref.tableExport(tableExportName);
            }
            hp.__(button.href(sendHref).action("action-Send").tooltipMessage("_ link.global.send").target("Edition"));
        }
        return true;
    }

    private static class FicheBdfHrefProvider
    extends BdfHrefProvider {
        private final String fiche;

        private FicheBdfHrefProvider(String fiche) {
            this.fiche = fiche;
        }

        @Override
        public BdfHref getSrc(String name) {
            switch (name) {
                case "List": {
                    BdfHref bdfHref = BH.domain("main").page("fiches");
                    String[] tokens = this.fiche.split("-");
                    if (tokens.length > 1) {
                        bdfHref.param("corpus", tokens[0]);
                        bdfHref.param("id", tokens[1]);
                    }
                    return bdfHref;
                }
                case "Edition": {
                    BdfHref bdfHref = new BdfHref("fiches/" + this.fiche + ".html", true);
                    return bdfHref;
                }
            }
            return null;
        }
    }

    private static class DefaultBdfHrefProvider
    extends BdfHrefProvider {
        private DefaultBdfHrefProvider() {
        }

        @Override
        public BdfHref getSrc(String name) {
            switch (name) {
                case "List": {
                    return BH.domain("main").page("fiches");
                }
                case "Edition": {
                    return BH.domain("main").page("start");
                }
            }
            return null;
        }
    }
}

