/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.tools.exportation.table.TableExportOds;
import net.fichotheque.tools.exportation.table.TableExportOdsFactory;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.util.io.StreamProducer;

public class TableExportOdsProducer
implements StreamProducer {
    private static final short MULTI_TYPE = 1;
    private static final short UNIQUE_TYPE = 2;
    private final String fileName;
    private final BdfParameters bdfParameters;
    private final short type;
    private final TableExport tableExport;
    private final Fiches fiches;
    private final SubsetTable uniqueSubsetTable;
    private final Collection<SubsetItem> uniqueSubsetItems;
    private final boolean merge;
    private final TableExportOdsParameters tableExportOdsParameters;

    private TableExportOdsProducer(String fileName, BdfParameters bdfParameters, TableExport tableExport, Fiches fiches, boolean merge, TableExportOdsParameters tableExportOdsParameters) {
        this.fileName = fileName;
        this.type = 1;
        this.bdfParameters = bdfParameters;
        this.tableExport = tableExport;
        this.fiches = fiches;
        this.uniqueSubsetTable = null;
        this.uniqueSubsetItems = null;
        this.tableExportOdsParameters = tableExportOdsParameters;
        this.merge = merge;
    }

    private TableExportOdsProducer(String fileName, BdfParameters bdfParameters, SubsetTable subsetTable, Collection<SubsetItem> subsetItems, TableExportOdsParameters tableExportOdsParameters) {
        this.fileName = fileName;
        this.type = (short)2;
        this.bdfParameters = bdfParameters;
        this.tableExport = null;
        this.fiches = null;
        this.uniqueSubsetTable = subsetTable;
        this.uniqueSubsetItems = subsetItems;
        this.tableExportOdsParameters = tableExportOdsParameters;
        this.merge = false;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        OdsOptions odsOptions = BdfServerUtils.buildOdsOptions(this.bdfParameters.getBdfServer(), "bdf://this/css/ods/tableexport.css").supplementarySheetWriter(BdfUserUtils.getSupplementarySheetWriter(this.bdfParameters));
        TableExportOds tableExportOds = this.initTableExportOds(odsOptions);
        tableExportOds.write(outputStream, this.isFixFirstRow());
    }

    private TableExportOds initTableExportOds(OdsOptions odsOptions) {
        if (this.type == 1) {
            if (this.merge) {
                String tableName = this.bdfParameters.getMessageLocalisation().toNotNullString("_ title.exportation.mergesheet");
                return TableExportOdsFactory.merge(tableName, this.tableExport, this.fiches, this.tableExportOdsParameters, odsOptions);
            }
            return TableExportOdsFactory.multi(this.tableExport, this.fiches, this.tableExportOdsParameters, odsOptions);
        }
        return TableExportOdsFactory.unique(this.uniqueSubsetTable, this.uniqueSubsetItems, this.tableExportOdsParameters, odsOptions);
    }

    private boolean isFixFirstRow() {
        if (this.tableExportOdsParameters.getHeaderType().equals("none")) {
            return false;
        }
        return this.type != 1 || !this.merge;
    }

    public static TableExportOdsProducer newMultiInstance(String fileName, BdfParameters bdfParameters, TableExport tableExport, Fiches fiches, boolean merge, TableExportOdsParameters tableExportOdsParameters) {
        return new TableExportOdsProducer(fileName, bdfParameters, tableExport, fiches, merge, tableExportOdsParameters);
    }

    public static TableExportOdsProducer newUniqueInstance(String fileName, BdfParameters bdfParameters, SubsetTable subsetTable, Collection<SubsetItem> subsetItemList, TableExportOdsParameters tableExportOdsParameters) {
        return new TableExportOdsProducer(fileName, bdfParameters, subsetTable, subsetItemList, tableExportOdsParameters);
    }
}

