/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleRemove";
    public static final String COMMANDKEY = "_ THS-12";
    private Motcle motcle;

    public MotcleRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Thesaurus thesaurus = this.motcle.getThesaurus();
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            FichothequeTools.remove(session.getFichothequeEditor(), this.motcle);
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.setDone("_ done.thesaurus.motcleremove", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!MotcleRemoveCommand.isRemoveCandidate(this.bdfServer, this.motcle)) {
            throw BdfErrors.error("_ error.notremoveable.motcle");
        }
    }

    public static boolean isRemoveCandidate(BdfServer bdfServer, Motcle motcle) {
        Subset[] subsetArray;
        DynamicEditPolicy dynamicEditPolicy = bdfServer.getPolicyManager().getPolicyProvider().getDynamicEditPolicy(motcle.getThesaurus());
        if (dynamicEditPolicy.isLax()) {
            return true;
        }
        Thesaurus thesaurus = motcle.getThesaurus();
        Fichotheque fichotheque = thesaurus.getFichotheque();
        if (motcle.isRemoveable()) {
            return true;
        }
        if (motcle.getChildList().size() > 0) {
            return false;
        }
        for (Subset subset : subsetArray = FichothequeUtils.toSubsetArray(fichotheque)) {
            Junctions junctions = motcle.getJunctions(subset);
            if (junctions.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

