/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class BalayageCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BalayageCreation";
    public static final String COMMANDKEY = "_ EXP-51";
    public static final String NEWBALAYAGE_PARAMNAME = "newbalayage";
    private String newBalayageName;

    public BalayageCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        String defaultName = "balayage.xml";
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        BalayageDescription balayageDescription = null;
        try (InputStream is = IOUtils.toInputStream(BalayageUtils.getDefaultContent(defaultName, ""), "UTF-8");){
            balayageDescription = this.bdfServer.getBalayageManager().putBalayageContent(this.newBalayageName, defaultName, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.balayagecontent_io", ioe.getMessage());
        }
        this.putResultObject("obj.templatedescription", balayageDescription);
        this.setDone("_ done.exportation.balayagecreation", this.newBalayageName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newBalayageName = this.getMandatory(NEWBALAYAGE_PARAMNAME).trim();
        if (this.newBalayageName.length() == 0) {
            throw BdfErrors.error("_ error.empty.balayagename");
        }
        if (!StringUtils.isTechnicalName(this.newBalayageName, true)) {
            throw BdfErrors.error("_ error.wrong.balayagename", this.newBalayageName);
        }
        if (BalayageCreationCommand.containsBalayageDescription(this.bdfServer.getBalayageManager(), this.newBalayageName)) {
            throw BdfErrors.error("_ error.existing.balayage", this.newBalayageName);
        }
    }

    private static boolean containsBalayageDescription(BalayageManager manager, String balayageName) {
        for (BalayageDescription balayageDescription : manager.getBalayageDescriptionList()) {
            if (!balayageDescription.getName().equals(balayageName)) continue;
            return true;
        }
        return false;
    }
}

