/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.tools.FichothequeTools;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class JunctionCopyCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "JunctionCopy";
    public static final String COMMANDKEY = "_ CRP-29";
    public static final String DESTINATION_PARAMNAME = "destination";
    public static final String DOCUMENTS_PARAMNAME = "documents";
    public static final String ILLUSTRATIONS_PARAMNAME = "illustrations";
    public static final String MOTCLES_PARAMNAME = "motcles";
    private FicheMeta origin;
    private FicheMeta destination;
    private JunctionSubsetEligibility junctionEligibility;

    public JunctionCopyCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("addenda", COMMANDNAME);){
            FichothequeTools.copyJunctions(session.getFichothequeEditor().getJunctionEditor(), this.origin, this.destination, this.junctionEligibility);
        }
        this.putResultObject("obj.corpus", this.origin.getCorpus());
        this.putResultObject("obj.fichemeta", this.origin);
        this.putResultObject("obj.destination", this.destination);
        this.setDone("_ done.corpus.junctioncopy", this.destination.getGlobalId());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.origin = this.requestHandler.getMandatoryFicheMeta();
        String destinationParam = this.getMandatory(DESTINATION_PARAMNAME);
        try {
            this.destination = (FicheMeta)this.bdfServer.getFichothequeQuestioner().parseGlobalId(destinationParam, (short)1, this.origin.getCorpus());
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.id", destinationParam);
        }
        this.getPermissionChecker().checkWrite(this.origin).checkWrite(this.destination);
        this.junctionEligibility = new JunctionSubsetEligibility();
        int count = 0;
        count += this.checkJunction(DOCUMENTS_PARAMNAME, (short)4);
        count += this.checkJunction(ILLUSTRATIONS_PARAMNAME, (short)5);
        if ((count += this.checkJunction(MOTCLES_PARAMNAME, (short)2)) == 0) {
            throw BdfErrors.error("_ error.empty.elementselection");
        }
    }

    private int checkJunction(String paramName, short subsetCategory) throws ErrorMessageException {
        String[] values = this.requestHandler.getTokens(paramName);
        int count = 0;
        for (String value : values) {
            try {
                SubsetItem subsetItem = this.bdfServer.getFichothequeQuestioner().parseGlobalId(value, subsetCategory, null);
                this.junctionEligibility.add(subsetItem);
                ++count;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return count;
    }

    private static class JunctionSubsetEligibility
    implements SubsetEligibility {
        private final Map<SubsetKey, JunctionPredicate> map = new HashMap<SubsetKey, JunctionPredicate>();

        private JunctionSubsetEligibility() {
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            return this.map.containsKey(subsetKey);
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            return this.map.get(subset.getSubsetKey());
        }

        private void add(SubsetItem subsetItem) {
            SubsetKey subsetKey = subsetItem.getSubsetKey();
            JunctionPredicate predicate = this.map.get(subsetKey);
            if (predicate == null) {
                predicate = new JunctionPredicate();
                this.map.put(subsetKey, predicate);
            }
            predicate.add(subsetItem);
        }
    }

    private static class JunctionPredicate
    implements Predicate<SubsetItem> {
        private final Set<SubsetItem> set = new HashSet<SubsetItem>();

        private JunctionPredicate() {
        }

        private void add(SubsetItem subsetItem) {
            this.set.add(subsetItem);
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.set.contains(subsetItem);
        }
    }
}

