/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.banque;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeColDefs;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.exportation.CategoryColumnDef;
import fr.exemole.bdfext.scarabe.tools.exportation.Columns;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.BH;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.date.FuzzyDateFormatter;
import net.mapeadores.util.date.RangeDateFilter;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.table.TableWriter;

public class GeneralTableEngine
extends TableEngine {
    private final BanqueDetail banqueDetail;
    private final ExtendedCurrency currency;
    private final OdTableDef odTableDef;
    private final String title;
    private long imputeTotal = 0L;
    private final Columns columns;
    private long debit = 0L;
    private long credit = 0L;

    public GeneralTableEngine(BanqueDetail banqueDetail, BdfParameters bdfParameters, ScarabeLocalisation scarabeLocalisation, ScarabeContext scarabeContext) {
        super(scarabeLocalisation);
        this.banqueDetail = banqueDetail;
        Banque banque = banqueDetail.getBanque();
        this.currency = banque.getCurrency();
        AliasHolder aliasHolder = scarabeContext.getCoreAliasHolder();
        List<ColDef> scarabeColDefList = aliasHolder.getCorpusField("mouvement_numerocheque") != null ? ScarabeColDefs.GENERAL_LIST : ScarabeColDefs.GENERAL_WITHOUT_CHEQUE;
        this.columns = Columns.build(bdfParameters, scarabeContext, scarabeLocalisation.getWorkingLang(), "banque_general", scarabeColDefList);
        OdTableDefBuilder odTableDefBuilder = new OdTableDefBuilder("");
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isNumeropiece(i)) {
                odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildStandard("PIECE"));
                continue;
            }
            if (this.columns.isMouvementid(i)) {
                odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildStandard("ID"));
                continue;
            }
            if (this.columns.isDebit(i)) {
                odTableDefBuilder.addCurrency(this.currency);
                continue;
            }
            if (this.columns.isCredit(i)) {
                odTableDefBuilder.addCurrency(this.currency);
                continue;
            }
            if (this.columns.isMontantimpute(i)) {
                odTableDefBuilder.addCurrency(this.currency);
                continue;
            }
            String formatCast = this.columns.getFormatCast(i);
            if (formatCast.equals("date")) {
                odTableDefBuilder.addDate(this.getDatePattern());
                continue;
            }
            odTableDefBuilder.addStandard();
        }
        this.odTableDef = odTableDefBuilder.toOdTableDef();
        this.title = this.initTitle(scarabeLocalisation);
    }

    private String initTitle(ScarabeLocalisation scarabeLocalisation) {
        Banque banque = this.banqueDetail.getBanque();
        RangeDateFilter rangeDateIntegerFilter = this.banqueDetail.getRangeDateIntegerFilter();
        StringBuilder buf = new StringBuilder();
        buf.append(banque.getTitle(scarabeLocalisation.getWorkingLang()));
        buf.append(" (");
        buf.append(scarabeLocalisation.getMessageLocalisation().toString("_ label.scarabe.detailtype_general"));
        buf.append(")");
        if (rangeDateIntegerFilter != null) {
            FuzzyDateFormatter formatter = scarabeLocalisation.getLongFuzzyDateFormatter();
            buf.append(" / ");
            FuzzyDate min = rangeDateIntegerFilter.getMinDate();
            buf.append(formatter.format(min));
            FuzzyDate max = rangeDateIntegerFilter.getMaxDate();
            if (!max.equals((Object)min)) {
                buf.append(" - ");
                buf.append(formatter.format(max));
            }
        }
        return buf.toString();
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
        int columnCount = this.columns.getCount();
        tableWriter.startRow((short)101);
        tableWriter.addStringCell(this.title, columnCount);
        tableWriter.endRow();
        tableWriter.startRow((short)103);
        this.writeTitles(tableWriter, this.columns.getColDefList());
        tableWriter.endRow();
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        for (Mouvement mouvement : this.banqueDetail.getMouvementList()) {
            this.printRows(tableWriter, mouvement);
        }
        this.printTotalRow(tableWriter);
    }

    private void printRows(ScarabeTableWriter tableWriter, Mouvement mouvement) {
        boolean firstLigne = true;
        firstLigne = this.printLigneList(tableWriter, mouvement, mouvement.getAvanceList(), firstLigne);
        firstLigne = this.printLigneList(tableWriter, mouvement, mouvement.getSoldeAvanceList(), firstLigne);
        firstLigne = this.printLigneList(tableWriter, mouvement, mouvement.getDepenseList(), firstLigne);
        this.printLigneList(tableWriter, mouvement, mouvement.getApportList(), firstLigne);
    }

    private boolean printLigneList(ScarabeTableWriter tableWriter, Mouvement mouvement, List<Ligne> ligneList, boolean firstLigne) {
        if (ligneList.isEmpty()) {
            return firstLigne;
        }
        for (Ligne ligne : ligneList) {
            this.printLigneRow(tableWriter, mouvement, ligne, firstLigne);
            firstLigne = false;
        }
        return false;
    }

    private void printLigneRow(ScarabeTableWriter tableWriter, Mouvement mouvement, Ligne ligne, boolean firstLigne) {
        tableWriter.startRow();
        if (firstLigne) {
            long mouvementMontant = mouvement.getMontantMoneyLong();
            if (mouvement.isDebit()) {
                this.debit += mouvementMontant;
            } else {
                this.credit += mouvementMontant;
            }
        }
        long montant = -ligne.getComputeMoneyLong();
        this.imputeTotal += montant;
        int columnCount = this.columns.getCount();
        this.columns.setCurrentFicheMeta(ligne.getFicheMeta());
        for (int i = 0; i < columnCount; ++i) {
            String href;
            if (this.columns.isDate(i)) {
                if (firstLigne) {
                    tableWriter.addDateCell(mouvement.getDate());
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isNumeropiece(i)) {
                if (firstLigne) {
                    tableWriter.addIntegerCell(mouvement.getNumeropiece());
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isMouvementid(i)) {
                if (firstLigne) {
                    href = BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)mouvement.getFicheMeta()).toString();
                    tableWriter.addHrefCell(href, mouvement.getId());
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isModepaiement(i)) {
                if (firstLigne) {
                    this.printMotcleCell(tableWriter, mouvement.getModepaiement());
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isNumerocheque(i)) {
                if (firstLigne) {
                    int numerocheque = mouvement.getNumerocheque();
                    if (numerocheque > -1) {
                        tableWriter.addIntegerCell(numerocheque);
                        continue;
                    }
                    tableWriter.addNullCell(1);
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isRapprochement(i)) {
                if (firstLigne) {
                    this.printMotcleCell(tableWriter, mouvement.getRapprochement());
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isDebit(i)) {
                if (firstLigne) {
                    if (mouvement.isDebit()) {
                        tableWriter.addMoneyCell(mouvement.getMontantMoneyLong(), this.currency);
                        continue;
                    }
                    tableWriter.addNullCell(1);
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isCredit(i)) {
                if (firstLigne) {
                    if (!mouvement.isDebit()) {
                        tableWriter.addMoneyCell(mouvement.getMontantMoneyLong(), this.currency);
                        continue;
                    }
                    tableWriter.addNullCell(1);
                    continue;
                }
                tableWriter.addNullCell(1);
                continue;
            }
            if (this.columns.isId(i)) {
                href = BH.domain((String)"edition").page("fiche-change").subsetItem((SubsetItem)ligne.getFicheMeta()).toString();
                String text = ScarabeUtils.getRaccourci(ligne.getLigneKey()) + "-" + String.valueOf(ligne.getId());
                tableWriter.addHrefCell(href, text);
                continue;
            }
            if (this.columns.isBeneficiaire(i)) {
                tableWriter.addStringCell(ligne.getBeneficiaireString());
                continue;
            }
            if (this.columns.isLibelle(i)) {
                tableWriter.addStringCell(ScarabeUtils.checkLibelle(ligne, this.getScarabeLocalisation()));
                continue;
            }
            if (this.columns.isMontantimpute(i)) {
                tableWriter.addMoneyCell(montant, this.currency);
                continue;
            }
            this.columns.getCurrentCell(i).write((TableWriter)tableWriter);
        }
        tableWriter.endRow();
    }

    private void printTotalRow(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)102);
        int columnCount = this.columns.getCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.isDebit(i)) {
                tableWriter.addMoneyCell(this.debit, this.currency);
                continue;
            }
            if (this.columns.isCredit(i)) {
                tableWriter.addMoneyCell(this.credit, this.currency);
                continue;
            }
            if (this.columns.isMontantimpute(i)) {
                tableWriter.addMoneyCell(this.imputeTotal, this.currency);
                continue;
            }
            tableWriter.addNullCell(1);
        }
        tableWriter.endRow();
    }

    private void printMotcleCell(ScarabeTableWriter tableWriter, Motcle motcle) {
        if (motcle == null) {
            tableWriter.addNullCell(1);
        } else {
            tableWriter.addStringCell(motcle.getIdalpha());
        }
    }
}

