/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.BH;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.fiche.AmountItem;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;

public class ResteWarningHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final Recapitulatif recapitulatif;
    private final ScarabeLocalisation scarabeLocalisation;

    public ResteWarningHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.setBodyCssClass("global-body-ListFrame");
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        this.scarabeLocalisation = ScarabeLocalisation.build(bdfParameters);
    }

    public void printHtml() {
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.restewarning")).UL();
        HtmlAttributes linkAttr = HA.href((CharSequence)"").target("Edition");
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter(FormatStyle.MEDIUM);
        for (Mouvement mouvement : this.recapitulatif.getResteWarningMouvementList()) {
            this.printMouvementLi(linkAttr, mouvement, dateTimeFormatter, symbols);
        }
        this._UL().__(PageUnit.END);
        this.end();
    }

    private void printMouvementLi(HtmlAttributes linkAttr, Mouvement mouvement, DateTimeFormatter dateTimeFormatter, DecimalFormatSymbols symbols) {
        this.LI();
        LocalDate date = mouvement.getDate();
        this.P().__localize("_ label.scarabe.numeropiece").__colon().__append(mouvement.getNumeropiece()).__dash().__localize("_ label.scarabe.date").__colon().__escape((CharSequence)dateTimeFormatter.format(date)).__dash().__localize("_ label.scarabe.libelle").__colon().__escape((CharSequence)mouvement.getLibelle())._P();
        this.UL();
        this.LI().P().__localize("_ label.scarabe.rappelmontant").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)mouvement.getMontantMoneyLong(), (ExtendedCurrency)mouvement.getCurrency(), (DecimalFormatSymbols)symbols, (boolean)true)).__space().__escape('(').__localize(mouvement.isDebit() ? "_ label.scarabe.debit" : "_ label.scarabe.credit").__escape(')')._P()._LI();
        this.printFichesLiees(mouvement.getAvanceList(), "_ label.scarabe.fiche_avance", symbols);
        this.printFichesLiees(mouvement.getSoldeAvanceList(), "_ label.scarabe.fiche_avance_solde", symbols);
        this.printFichesLiees(mouvement.getDepenseList(), "_ label.scarabe.fiche_depense", symbols);
        this.printFichesLiees(mouvement.getApportList(), "_ label.scarabe.fiche_apport", symbols);
        this.LI().P().__localize("_ label.scarabe.reste").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)mouvement.getResteMoneyLong(), (ExtendedCurrency)mouvement.getCurrency(), (DecimalFormatSymbols)symbols, (boolean)true))._P()._LI();
        this.LI().A(linkAttr.href((CharSequence)BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)mouvement.getFicheMeta()))).__localize("_ link.scarabe.mouvementresult")._A()._LI();
        this._UL();
        this._LI();
    }

    private void printFichesLiees(List<Ligne> ligneList, String messageKey, DecimalFormatSymbols symbols) {
        for (Ligne ligne : ligneList) {
            AmountItem montant = ligne.getAmountItem();
            this.LI().P().EM().__localize(messageKey).__colon()._EM().__escape((CharSequence)ScarabeUtils.checkLibelle(ligne, this.scarabeLocalisation)).__colon().__escape((CharSequence)MoneyUtils.toLitteralString((Decimal)montant.getDecimal(), (ExtendedCurrency)montant.getCurrency(), (DecimalFormatSymbols)symbols))._P()._LI();
        }
    }
}

