/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Consumer;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.HtmlPrinter;

public class PastDateWarningHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final Recapitulatif recapitulatif;

    public PastDateWarningHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.setBodyCssClass("global-body-ListFrame");
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
    }

    public void printHtml() {
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter(FormatStyle.MEDIUM);
        this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.pastdatewarning")).UL();
        for (Avenir avenir : this.recapitulatif.getPastDateWarningAvenirList()) {
            this.printAvenirLi(avenir, dateTimeFormatter);
        }
        this._UL().__(PageUnit.END);
        this.end();
    }

    private void printAvenirLi(Avenir avenir, DateTimeFormatter dateTimeFormatter) {
        FicheMeta ficheMeta = avenir.getFicheMeta();
        String title = ficheMeta.getTitle();
        if (title.length() == 0) {
            title = "__";
        }
        LocalDate date = avenir.getDatePrevue();
        this.LI().P().__escape((CharSequence)title).__(ScarabeHtmlUtils.printDisplayButton((HtmlPrinter)this, ficheMeta)).__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, ficheMeta)).BR().SPAN("global-Warning").__escape((CharSequence)date.toString()).__space().__escape('(').__escape((CharSequence)dateTimeFormatter.format(date)).__escape(')')._SPAN()._P()._LI();
    }
}

